/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

public class OutputBuffer {
    public static final int BUFFERSIZE = 2304;
    private static final int MAXCHANNELS = 2;
    private Float replayGainScale;
    private int channels;
    private byte[] buffer;
    private int[] channelPointer;
    private boolean isBigEndian;

    public OutputBuffer(int n, boolean bl) {
        this.channels = n;
        this.isBigEndian = bl;
        this.buffer = new byte[2304 * n];
        this.channelPointer = new int[n];
        this.reset();
    }

    private void append(int n, short s) {
        byte by;
        byte by2;
        if (this.isBigEndian) {
            by2 = (byte)(s >>> 8 & 0xFF);
            by = (byte)(s & 0xFF);
        } else {
            by2 = (byte)(s & 0xFF);
            by = (byte)(s >>> 8 & 0xFF);
        }
        this.buffer[this.channelPointer[n]] = by2;
        this.buffer[this.channelPointer[n] + 1] = by;
        int n2 = n;
        this.channelPointer[n2] = this.channelPointer[n2] + this.channels * 2;
    }

    public void appendSamples(int n, float[] fArray) {
        if (this.replayGainScale != null) {
            int n2 = 0;
            while (n2 < 32) {
                short s = this.clip(fArray[n2++] * this.replayGainScale.floatValue());
                this.append(n, s);
            }
        } else {
            int n3 = 0;
            while (n3 < 32) {
                short s = this.clip(fArray[n3++]);
                this.append(n, s);
            }
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reset() {
        int n;
        try {
            int n2 = this.channels - 1;
            n = this.channelPointer[n2] - n2 * 2;
        }
        catch (Throwable throwable) {
            for (int i = 0; i < this.channels; ++i) {
                this.channelPointer[i] = i * 2;
            }
            throw throwable;
        }
        for (int i = 0; i < this.channels; ++i) {
            this.channelPointer[i] = i * 2;
        }
        return n;
    }

    public void setReplayGainScale(Float f) {
        this.replayGainScale = f;
    }

    public boolean isStereo() {
        return this.channelPointer[1] == 2;
    }

    private final short clip(float f) {
        return (short)(f > 32767.0f ? Short.MAX_VALUE : (short)(f < -32768.0f ? Short.MIN_VALUE : (short)f));
    }
}

