/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SharedLibraryLoader {
    private static Set<String> loadedLibraries = new HashSet<String>();
    private String nativesJar;

    public SharedLibraryLoader() {
    }

    public SharedLibraryLoader(String nativesJar) {
        this.nativesJar = nativesJar;
    }

    private String crc(String nativeFile) {
        InputStream input = SharedLibraryLoader.class.getResourceAsStream("/" + nativeFile);
        if (input == null) {
            return "" + System.nanoTime();
        }
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[4096];
        try {
            int length;
            while ((length = input.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (Exception ex) {
            try {
                input.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return Long.toString(crc.getValue());
    }

    private boolean loadLibrary(String sharedLibName) {
        String path = this.extractLibrary(sharedLibName);
        if (path != null) {
            System.load(path);
        }
        return path != null;
    }

    private String extractLibrary(String sharedLibName) {
        File nativesDir = new File(System.getProperty("java.io.tmpdir") + "/jnigen/" + this.crc(sharedLibName));
        File nativeFile = new File(nativesDir, sharedLibName);
        try {
            int length;
            InputStream input = null;
            input = this.nativesJar == null ? SharedLibraryLoader.class.getResourceAsStream("/" + sharedLibName) : this.getFromJar(this.nativesJar, sharedLibName);
            if (input == null) {
                return null;
            }
            nativesDir.mkdirs();
            FileOutputStream output = new FileOutputStream(nativeFile);
            byte[] buffer = new byte[4096];
            while ((length = input.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            input.close();
            output.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return nativeFile.exists() ? nativeFile.getAbsolutePath() : null;
    }

    private InputStream getFromJar(String jarFile, String sharedLibrary) throws IOException {
        ZipFile file = new ZipFile(this.nativesJar);
        ZipEntry entry = file.getEntry(sharedLibrary);
        if (entry == null) {
            throw new GdxRuntimeException("Couldn't find " + sharedLibrary + " in jar " + jarFile);
        }
        return file.getInputStream(entry);
    }

    public synchronized void load(String sharedLibName) {
        if (loadedLibraries.contains(sharedLibName)) {
            return;
        }
        boolean isWindows = System.getProperty("os.name").contains("Windows");
        boolean isLinux = System.getProperty("os.name").contains("Linux");
        boolean isMac = System.getProperty("os.name").contains("Mac");
        boolean isAndroid = false;
        boolean is64Bit = System.getProperty("os.arch").equals("amd64");
        String vm = System.getProperty("java.vm.name");
        if (vm != null && vm.contains("Dalvik")) {
            isAndroid = true;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
        boolean loaded = false;
        if (isWindows) {
            loaded = !is64Bit ? this.loadLibrary(sharedLibName + ".dll") : this.loadLibrary(sharedLibName + "64.dll");
        }
        if (isLinux) {
            loaded = !is64Bit ? this.loadLibrary("lib" + sharedLibName + ".so") : this.loadLibrary("lib" + sharedLibName + "64.so");
        }
        if (isMac) {
            loaded = this.loadLibrary("lib" + sharedLibName + ".dylib");
        }
        if (isAndroid) {
            System.loadLibrary(sharedLibName);
            loaded = true;
        }
        if (!loaded) {
            throw new RuntimeException("Couldn't load shared library: '" + sharedLibName + "' for target " + System.getProperty("os.name") + ", " + (is64Bit ? "64-bit" : "32-bit"));
        }
        loadedLibraries.add(sharedLibName);
    }
}

