/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui.tablelayout;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.ClickListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.LibgdxToolkit;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.TableLayout;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;
import com.esotericsoftware.tablelayout.Cell;
import com.esotericsoftware.tablelayout.ParseException;
import java.util.List;

public class Table
extends WidgetGroup {
    private final TableLayout layout;
    private NinePatch backgroundPatch;
    private final Rectangle tableBounds = new Rectangle();
    private final Rectangle scissors = new Rectangle();
    private ClickListener listener;
    public boolean clip;
    public boolean isPressed;

    public Table() {
        this(null, null, null);
    }

    public Table(String name) {
        this(null, null, name);
    }

    public Table(Skin skin) {
        this(skin, null, null);
    }

    public Table(Skin skin, TableLayout layout, String name) {
        super(name);
        this.transform = false;
        if (layout == null) {
            layout = new TableLayout();
        }
        this.layout = layout;
        layout.setTable(this);
        layout.skin = skin;
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        this.validate();
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        this.drawBackground(batch, parentAlpha);
        if (this.transform) {
            this.applyTransform(batch);
            if (this.clip) {
                this.calculateScissors(batch.getTransformMatrix());
                if (ScissorStack.pushScissors(this.scissors)) {
                    this.drawChildren(batch, parentAlpha);
                    ScissorStack.popScissors();
                }
            } else {
                this.drawChildren(batch, parentAlpha);
            }
            this.resetTransform(batch);
        } else {
            super.draw(batch, parentAlpha);
        }
    }

    protected void drawBackground(SpriteBatch batch, float parentAlpha) {
        if (this.backgroundPatch != null) {
            batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
            this.backgroundPatch.draw(batch, this.x, this.y, this.width, this.height);
        }
    }

    private void calculateScissors(Matrix4 transform) {
        this.tableBounds.x = 0.0f;
        this.tableBounds.y = 0.0f;
        this.tableBounds.width = this.width;
        this.tableBounds.height = this.height;
        if (this.backgroundPatch != null) {
            this.tableBounds.x += (float)((LibgdxToolkit)this.layout.getToolkit()).width(this.layout, this.layout.getPadLeft());
            this.tableBounds.y += (float)((LibgdxToolkit)this.layout.getToolkit()).width(this.layout, this.layout.getPadBottom());
            this.tableBounds.width -= this.tableBounds.x + (float)((LibgdxToolkit)this.layout.getToolkit()).width(this.layout, this.layout.getPadRight());
            this.tableBounds.height -= this.tableBounds.y + (float)((LibgdxToolkit)this.layout.getToolkit()).width(this.layout, this.layout.getPadTop());
        }
        ScissorStack.calculateScissors(this.stage.getCamera(), transform, this.tableBounds, this.scissors);
    }

    @Override
    public void invalidate() {
        this.layout.invalidate();
        super.invalidate();
    }

    @Override
    public float getPrefWidth() {
        if (this.backgroundPatch != null) {
            return Math.max(this.layout.getPrefWidth(), (int)this.backgroundPatch.getTotalWidth());
        }
        return this.layout.getPrefWidth();
    }

    @Override
    public float getPrefHeight() {
        if (this.backgroundPatch != null) {
            return Math.max(this.layout.getPrefHeight(), (int)this.backgroundPatch.getTotalHeight());
        }
        return this.layout.getPrefHeight();
    }

    @Override
    public float getMinWidth() {
        return this.layout.getMinWidth();
    }

    @Override
    public float getMinHeight() {
        return this.layout.getMinHeight();
    }

    public void setBackground(NinePatch background) {
        if (this.backgroundPatch == background) {
            return;
        }
        this.backgroundPatch = background;
        if (background == null) {
            this.pad(null);
        } else {
            this.padBottom((int)background.getBottomHeight());
            this.padTop((int)background.getTopHeight());
            this.padLeft((int)background.getLeftWidth());
            this.padRight((int)background.getRightWidth());
            this.invalidate();
        }
    }

    public NinePatch getBackgroundPatch() {
        return this.backgroundPatch;
    }

    public void setClip(boolean enabled) {
        this.clip = enabled;
        this.transform = enabled;
        this.invalidate();
    }

    public void setClickListener(ClickListener listener) {
        this.listener = listener;
    }

    public ClickListener getClickListener() {
        return this.listener;
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (super.touchDown(x, y, pointer)) {
            return true;
        }
        if (pointer != 0) {
            return false;
        }
        if (this.listener == null) {
            return false;
        }
        this.isPressed = true;
        return true;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        if (this.hit(x, y) != null) {
            this.click(x, y);
        }
        this.isPressed = false;
    }

    public void click(float x, float y) {
        if (this.listener != null) {
            this.listener.click(this, x, y);
        }
    }

    public int getRow(float y) {
        return this.layout.getRow(y);
    }

    public TableLayout getTableLayout() {
        return this.layout;
    }

    @Override
    public void clear() {
        super.clear();
        this.layout.clear();
        this.invalidate();
    }

    public Actor register(String name, Actor widget) {
        return this.layout.register(name, widget);
    }

    public Cell add(String text) {
        if (this.layout.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add(new Label((CharSequence)text, this.layout.skin));
    }

    public Cell add() {
        return this.add((Actor)null);
    }

    public Cell add(Actor actor) {
        return this.layout.add(actor);
    }

    public Cell stack(Actor ... actor) {
        return this.layout.stack(actor);
    }

    public Table newTable() {
        return ((LibgdxToolkit)this.layout.getToolkit()).newTable(this);
    }

    public Cell row() {
        return this.layout.row();
    }

    public void parse(FileHandle tableDescriptionFile) {
        try {
            this.layout.parse(tableDescriptionFile.readString());
        }
        catch (ParseException ex) {
            throw new ParseException("Error parsing layout file: " + tableDescriptionFile, ex);
        }
    }

    public void parse(String tableDescription) {
        this.layout.parse(tableDescription);
    }

    public Cell columnDefaults(int column) {
        return this.layout.columnDefaults(column);
    }

    public Cell defaults() {
        return this.layout.defaults();
    }

    @Override
    public void layout() {
        this.layout.layout();
    }

    public void reset() {
        this.layout.reset();
    }

    public Actor getWidget(String name) {
        return this.layout.getWidget(name);
    }

    public List<Actor> getWidgets() {
        return this.layout.getWidgets();
    }

    public List<Actor> getWidgets(String namePrefix) {
        return this.layout.getWidgets(namePrefix);
    }

    public Cell getCell(Actor actor) {
        return this.layout.getCell(actor);
    }

    public Cell getCell(String name) {
        return this.layout.getCell(name);
    }

    public List<Cell> getAllCells() {
        return this.layout.getAllCells();
    }

    public List<Cell> getAllCells(String namePrefix) {
        return this.layout.getAllCells(namePrefix);
    }

    public List<Cell> getCells() {
        return this.layout.getCells();
    }

    public void setWidget(String name, Actor actor) {
        this.layout.setWidget(name, actor);
    }

    public Table size(String width, String height) {
        this.layout.size(width, height);
        return this;
    }

    public Table width(String width) {
        this.layout.width(width);
        return this;
    }

    public Table height(String height) {
        this.layout.height(height);
        return this;
    }

    public Table size(int width, int height) {
        this.layout.size(width, height);
        return this;
    }

    public Table width(int width) {
        this.layout.width(width);
        return this;
    }

    public Table height(int height) {
        this.layout.height(height);
        return this;
    }

    public Table pad(String pad) {
        this.layout.pad(pad);
        return this;
    }

    public Table pad(String top, String left, String bottom, String right) {
        this.layout.pad(top, left, bottom, right);
        return this;
    }

    public Table padTop(String padTop) {
        this.layout.padTop(padTop);
        return this;
    }

    public Table padLeft(String padLeft) {
        this.layout.padLeft(padLeft);
        return this;
    }

    public Table padBottom(String padBottom) {
        this.layout.padBottom(padBottom);
        return this;
    }

    public Table padRight(String padRight) {
        this.layout.padRight(padRight);
        return this;
    }

    public Table pad(int pad) {
        this.layout.pad(pad);
        return this;
    }

    public Table pad(int top, int left, int bottom, int right) {
        this.layout.pad(top, left, bottom, right);
        return this;
    }

    public Table padTop(int padTop) {
        this.layout.padTop(padTop);
        return this;
    }

    public Table padLeft(int padLeft) {
        this.layout.padLeft(padLeft);
        return this;
    }

    public Table padBottom(int padBottom) {
        this.layout.padBottom(padBottom);
        return this;
    }

    public Table padRight(int padRight) {
        this.layout.padRight(padRight);
        return this;
    }

    public Table align(int align) {
        this.layout.align(align);
        return this;
    }

    public Table align(String value) {
        this.layout.align(value);
        return this;
    }

    public Table center() {
        this.layout.center();
        return this;
    }

    public Table top() {
        this.layout.top();
        return this;
    }

    public Table left() {
        this.layout.left();
        return this;
    }

    public Table bottom() {
        this.layout.bottom();
        return this;
    }

    public Table right() {
        this.layout.right();
        return this;
    }

    public Table debug() {
        this.layout.debug();
        return this;
    }

    public Table debug(int debug) {
        this.layout.debug(debug);
        return this;
    }

    public Table debug(String value) {
        this.layout.debug(value);
        return this;
    }

    public int getDebug() {
        return this.layout.getDebug();
    }

    public String getHeight() {
        return this.layout.getHeight();
    }

    public String getPadTop() {
        return this.layout.getPadTop();
    }

    public String getPadLeft() {
        return this.layout.getPadLeft();
    }

    public String getPadBottom() {
        return this.layout.getPadBottom();
    }

    public String getPadRight() {
        return this.layout.getPadRight();
    }

    public int getAlign() {
        return this.layout.getAlign();
    }

    public void setSkin(Skin skin) {
        this.layout.skin = skin;
    }

    public void setAssetManager(AssetManager assetManager) {
        this.layout.assetManager = assetManager;
    }

    public static void drawDebug(Stage stage) {
        if (!LibgdxToolkit.drawDebug) {
            return;
        }
        Table.drawDebug(stage.getActors(), stage.getSpriteBatch());
    }

    private static void drawDebug(List<Actor> actors, SpriteBatch batch) {
        int n = actors.size();
        for (int i = 0; i < n; ++i) {
            Actor actor = actors.get(i);
            if (actor instanceof Table) {
                ((Table)actor).layout.drawDebug(batch);
            }
            if (!(actor instanceof Group)) continue;
            Table.drawDebug(((Group)actor).getActors(), batch);
        }
    }
}

