/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.interpolators;

import com.badlogic.gdx.scenes.scene2d.Interpolator;
import com.badlogic.gdx.utils.Pool;

public class AnticipateInterpolator
implements Interpolator {
    private static final float DEFAULT_TENSION = 2.0f;
    private static final Pool<AnticipateInterpolator> pool = new Pool<AnticipateInterpolator>(4, 100){

        @Override
        protected AnticipateInterpolator newObject() {
            return new AnticipateInterpolator();
        }
    };
    private float tension;

    AnticipateInterpolator() {
    }

    public static AnticipateInterpolator $(float tension) {
        AnticipateInterpolator inter = pool.obtain();
        inter.tension = tension;
        return inter;
    }

    public static AnticipateInterpolator $() {
        return AnticipateInterpolator.$(2.0f);
    }

    @Override
    public void finished() {
        pool.free(this);
    }

    @Override
    public float getInterpolation(float t) {
        return t * t * ((this.tension + 1.0f) * t - this.tension);
    }

    @Override
    public Interpolator copy() {
        return AnticipateInterpolator.$(this.tension);
    }
}

