/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl.LwjglFiles;
import com.badlogic.gdx.backends.lwjgl.LwjglGraphics;
import com.badlogic.gdx.backends.lwjgl.LwjglInput;
import com.badlogic.gdx.backends.lwjgl.LwjglNativesLoader;
import com.badlogic.gdx.backends.lwjgl.LwjglPreferences;
import com.badlogic.gdx.backends.openal.OpenALAudio;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.awt.Canvas;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;

public class LwjglApplication
implements Application {
    LwjglGraphics graphics;
    OpenALAudio audio;
    LwjglFiles files;
    LwjglInput input;
    final ApplicationListener listener;
    Thread mainLoopThread;
    boolean running = true;
    List<Runnable> runnables = new ArrayList<Runnable>();
    List<Runnable> executedRunnables = new ArrayList<Runnable>();
    int logLevel = 2;
    Map<String, Preferences> preferences = new HashMap<String, Preferences>();

    public LwjglApplication(ApplicationListener listener, String title, int width, int height, boolean useGL2) {
        LwjglNativesLoader.load();
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        config.title = title;
        config.width = width;
        config.height = height;
        config.useGL20 = useGL2;
        config.vSyncEnabled = true;
        this.graphics = new LwjglGraphics(config);
        this.audio = new OpenALAudio(16, config.audioDeviceBufferCount, config.audioDeviceBufferSize);
        this.files = new LwjglFiles();
        this.input = new LwjglInput();
        this.listener = listener;
        Gdx.app = this;
        Gdx.graphics = this.graphics;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.input = this.input;
        this.initialize();
    }

    public LwjglApplication(ApplicationListener listener, LwjglApplicationConfiguration config) {
        LwjglNativesLoader.load();
        this.graphics = new LwjglGraphics(config);
        this.audio = new OpenALAudio(16, config.audioDeviceBufferCount, config.audioDeviceBufferSize);
        this.files = new LwjglFiles();
        this.input = new LwjglInput();
        this.listener = listener;
        Gdx.app = this;
        Gdx.graphics = this.graphics;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.input = this.input;
        this.initialize();
    }

    public LwjglApplication(ApplicationListener listener, boolean useGL2, Canvas canvas) {
        LwjglNativesLoader.load();
        this.graphics = new LwjglGraphics(canvas, useGL2);
        this.audio = new OpenALAudio();
        this.files = new LwjglFiles();
        this.input = new LwjglInput();
        this.listener = listener;
        Gdx.app = this;
        Gdx.graphics = this.graphics;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.input = this.input;
        this.initialize();
    }

    public LwjglApplication(ApplicationListener listener, LwjglApplicationConfiguration config, Canvas canvas) {
        LwjglNativesLoader.load();
        this.graphics = new LwjglGraphics(canvas, config);
        this.audio = new OpenALAudio(16, config.audioDeviceBufferCount, config.audioDeviceBufferSize);
        this.files = new LwjglFiles();
        this.input = new LwjglInput();
        this.listener = listener;
        Gdx.app = this;
        Gdx.graphics = this.graphics;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.input = this.input;
        this.initialize();
    }

    private void initialize() {
        this.mainLoopThread = new Thread("LWJGL Application"){

            @Override
            public void run() {
                LwjglApplication.this.graphics.setVSync(LwjglApplication.this.graphics.config.vSyncEnabled);
                LwjglApplication.this.mainLoop();
            }
        };
        this.mainLoopThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mainLoop() {
        try {
            this.graphics.setupDisplay();
        }
        catch (LWJGLException e) {
            throw new GdxRuntimeException(e);
        }
        this.listener.create();
        this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
        this.graphics.resize = false;
        int lastWidth = this.graphics.getWidth();
        int lastHeight = this.graphics.getHeight();
        this.graphics.lastTime = System.nanoTime();
        while (this.running) {
            Display.processMessages();
            if (Display.isCloseRequested()) {
                this.exit();
            }
            boolean shouldRender = false;
            List<Runnable> list = this.runnables;
            synchronized (list) {
                this.executedRunnables.clear();
                this.executedRunnables.addAll(this.runnables);
                this.runnables.clear();
                for (int i = 0; i < this.executedRunnables.size(); ++i) {
                    shouldRender = true;
                    try {
                        this.executedRunnables.get(i).run();
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            this.input.update();
            shouldRender |= this.graphics.shouldRender();
            if (this.graphics.canvas != null) {
                int width = this.graphics.canvas.getWidth();
                int height = this.graphics.canvas.getHeight();
                if (lastWidth != width || lastHeight != height) {
                    lastWidth = width;
                    lastHeight = height;
                    Gdx.gl.glViewport(0, 0, lastWidth, lastHeight);
                    this.listener.resize(lastWidth, lastHeight);
                    shouldRender = true;
                }
            } else if (this.graphics.resize || Display.wasResized() || Display.getWidth() != this.graphics.config.width || Display.getHeight() != this.graphics.config.height) {
                this.graphics.resize = false;
                Gdx.gl.glViewport(0, 0, Display.getWidth(), Display.getHeight());
                this.graphics.config.width = Display.getWidth();
                this.graphics.config.height = Display.getHeight();
                if (this.listener != null) {
                    this.listener.resize(Display.getWidth(), Display.getHeight());
                }
                this.graphics.requestRendering();
            }
            this.input.processEvents();
            this.audio.update();
            if (shouldRender) {
                this.graphics.updateTime();
                this.listener.render();
                Display.update();
                if (!this.graphics.vsync || !this.graphics.config.useCPUSynch) continue;
                Display.sync(60);
                continue;
            }
            Display.sync(60);
        }
        this.listener.pause();
        this.listener.dispose();
        Display.destroy();
        this.audio.dispose();
        if (this.graphics.config.forceExit) {
            System.exit(-1);
        }
    }

    @Override
    public Audio getAudio() {
        return this.audio;
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    @Override
    public LwjglGraphics getGraphics() {
        return this.graphics;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.Desktop;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    public void stop() {
        this.running = false;
        try {
            this.mainLoopThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    @Override
    public Preferences getPreferences(String name) {
        if (this.preferences.containsKey(name)) {
            return this.preferences.get(name);
        }
        LwjglPreferences prefs = new LwjglPreferences(name);
        this.preferences.put(name, prefs);
        return prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRunnable(Runnable runnable) {
        List<Runnable> list = this.runnables;
        synchronized (list) {
            this.runnables.add(runnable);
            Gdx.graphics.requestRendering();
        }
    }

    @Override
    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
        }
    }

    @Override
    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    @Override
    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
        }
    }

    @Override
    public void log(String tag, String message, Exception exception) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    @Override
    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
        }
    }

    @Override
    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
            exception.printStackTrace(System.err);
        }
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void exit() {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                LwjglApplication.this.running = false;
            }
        });
    }
}

