/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class World_Text
extends World {
    protected String[] lines;
    protected App_MinerMan app_mm;
    protected String path = "";
    protected boolean scroll;
    protected BitmapFont font;
    protected float y;
    protected float h;

    public World_Text(App a) {
        super(a);
        this.app_mm = (App_MinerMan)a;
    }

    @Override
    public void create() {
        this.font = new BitmapFont();
        String text = "";
        InputStream in = Gdx.files.internal(this.path).read();
        try {
            text = new Scanner(in).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        text = text.replaceAll("\r\n", "\n");
        text = text.replaceAll("\r", "\n");
        this.lines = text.split("\n");
        this.h = this.lines.length * 18 + 300;
        this.y = this.scroll ? 0 : 280;
    }

    @Override
    public void update() {
        super.update();
        if (App.keyPressed == 66 || App.keyPressed == 131 || App.keyPressed == 62) {
            this.app_mm.setWorld(this.app_mm.menu);
        }
    }

    @Override
    public void render() {
        this.app_mm.game.render();
        this.spriteBatch.begin();
        World_Text.camera.zoom = 0.5f;
        World_Text.camera.position.x = 200.0f;
        World_Text.camera.position.y = 150.0f;
        this.useCamera();
        this.spriteBatch.draw(this.app_mm.game.objectsTRegion[6][1], 0.0f, 0.0f, 400.0f, 300.0f);
        this.font.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.scroll) {
            this.y += 1.0f;
            if (this.y > this.h) {
                this.y = 0.0f;
            }
        }
        float ty = this.y;
        int row = 0;
        while (row < this.lines.length) {
            String line = this.lines[row];
            this.font.draw(this.spriteBatch, line, 20.0f, ty);
            ty -= 18.0f;
            if (line.length() == 0) {
                this.font.setColor(1.0f, 1.0f, 0.0f, 1.0f);
            } else {
                this.font.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
            ++row;
        }
        this.spriteBatch.end();
    }
}

