/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.ArrayList;

public abstract class World {
    protected static OrthographicCamera camera;
    protected SpriteBatch spriteBatch;
    protected ArrayList<GameSprite> sprites;
    protected Grid grid;
    protected EntityManager entityMgr;
    protected Sound[] sound;
    protected App app;
    public boolean skipUpdate;

    public World(App a) {
        this.app = a;
        camera = new OrthographicCamera();
        this.spriteBatch = new SpriteBatch();
        this.sprites = new ArrayList();
        this.entityMgr = new EntityManager(a);
    }

    public App getApp() {
        return this.app;
    }

    public void confirmOk() {
    }

    public void confirmCancel() {
    }

    public void playSound(int s, float vol) {
        if (this.app.config.getInt("sound", 0) == 0) {
            return;
        }
        this.sound[s].play(vol);
    }

    public void playSound(int s) {
        this.playSound(s, 1.0f);
    }

    public Grid getGrid() {
        return this.grid;
    }

    public EntityManager getEntityManager() {
        return this.entityMgr;
    }

    public void addSprite(GameSprite sprite) {
        this.sprites.add(sprite);
    }

    public void removeSprite(Sprite sprite) {
        this.sprites.remove(sprite);
        sprite = null;
    }

    public void addEntity(Entity e) {
        this.entityMgr.add(e);
    }

    public void removeEntity(Entity e) {
        this.entityMgr.remove(e);
    }

    public OrthographicCamera getCamera() {
        return camera;
    }

    public abstract void create();

    public void update() {
        this.entityMgr.update();
    }

    protected void render() {
    }

    protected void renderSprites(int layer) {
        int size = this.sprites.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                GameSprite s = this.sprites.get(i);
                if (s.isVisible() && s.getLayer() == layer) {
                    s.draw(this.spriteBatch);
                }
                ++i;
            }
        }
    }

    public void clearScreen() {
        Gdx.gl10.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl10.glClear(16384);
    }

    protected void useCamera() {
        Gdx.gl10.glEnable(3553);
        Gdx.gl10.glDisable(2884);
        Gdx.gl10.glDisable(2929);
        camera.update();
        camera.apply(Gdx.gl10);
    }

    public void removeSprites() {
        for (GameSprite s : this.sprites) {
            Object var2_2 = null;
        }
        this.sprites.clear();
    }

    public void resize(int width, int height) {
        float aspectRatio = (float)width / (float)height;
        camera = new OrthographicCamera(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        camera.setToOrtho(false, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }
}

