/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;

public class User {
    private Entity_Player entity;
    private Vector2 speed = new Vector2();
    private Vector2 maxSpeed = new Vector2(5.0f, 15.9f);
    private Vector2 acc = new Vector2(1.4f, 2.0f);
    private boolean canJump;
    private int jumpCounter;
    private float walkTime;
    private float oldWalkTime;
    private Animation walkAnim;
    private float godTime;
    private float startTime;
    private float stepTime;
    private int hearth;
    private int hearthBackup;
    public int live;
    private int gold = 0;
    private boolean died;
    private boolean down;
    private int boxSound;
    private App_MinerMan app;
    private World_Game game;
    private BitmapFont font;

    public User(App_MinerMan a) {
        this.app = a;
        this.game = a.game;
        this.hearth = this.app.config.getInt("hearth", 3);
        this.live = this.app.config.getInt("live", 3);
        this.boxSound = 0;
    }

    public void create() {
        this.font = new BitmapFont();
        this.walkAnim = new Animation(0.15f, this.app.game.objectsTRegion[0][0], this.app.game.objectsTRegion[0][1]);
        this.walkTime = 0.0f;
        this.startTime = 2.0f;
    }

    public void reset() {
        this.app.config.setInt("live", 3);
        this.app.config.setInt("hearth", 3);
        this.live = 3;
    }

    public void clear() {
        this.godTime = 0.0f;
        this.gold = 0;
        this.entity = null;
        this.died = false;
        this.speed.set(0.0f, 0.0f);
        this.jumpCounter = 0;
        this.hearth = this.app.config.getInt("hearth", 3);
    }

    public void setEntity(Entity_Player e) {
        this.entity = e;
    }

    public Entity_Player getEntity() {
        return this.entity;
    }

    public int getGoldCount() {
        return this.gold;
    }

    public void gameOver() {
        this.game.removeEntity(this.entity);
        this.app.confirm.msg = "GAME OVER";
        this.app.confirm.prevWorld = this.game;
        --this.live;
        if (this.live <= 0) {
            this.app.menu.itemContinue.disabled = true;
            this.app.menu.activeId = 1;
            this.game.lastConfirm = 3;
            this.app.confirm.okText = "Restart game";
            this.app.confirm.cancelText = "Back to menu";
        } else {
            this.game.lastConfirm = 1;
            this.app.confirm.okText = "Restart level";
            this.app.confirm.cancelText = "Back to menu";
        }
        this.app.confirm.init();
        this.app.setWorld(this.app.confirm);
        this.game.playSound(6);
        this.app.config.setInt("live", this.live);
        this.app.config.save();
    }

    public void update() {
        int t;
        boolean jumpButtonDown;
        if (this.entity == null) {
            return;
        }
        this.entity.clipperEntity = null;
        if (this.godTime == 2.0f) {
            this.speed.y = 7.0f;
        }
        if (this.died) {
            if (this.entity.position.y < 0.0f) {
                this.gameOver();
                return;
            }
            this.godTime = 0.0f;
            this.speed.y -= this.acc.y;
            this.entity.sprite.setRegion(this.game.objectsTRegion[0][1]);
            this.entity.position.x += this.speed.x;
            this.entity.position.y += this.speed.y;
            return;
        }
        boolean bl = jumpButtonDown = App.isKeyDown(34) || App.isKeyDown(62);
        if (jumpButtonDown && (this.canJump || this.jumpCounter > 0) && this.jumpCounter < 4) {
            this.speed.y = 11.0f;
            ++this.jumpCounter;
            this.startTime = 0.0f;
        } else {
            this.jumpCounter = 0;
        }
        this.speed.y -= this.acc.y;
        this.godTime -= this.app.getDeltaTime();
        if (this.godTime < 0.0f) {
            this.godTime = 0.0f;
            this.entity.sprite.setVisible(true);
        } else {
            t = (int)(this.godTime * 10.0f);
            this.entity.sprite.setVisible(t % 2 == 0);
        }
        if (this.startTime > 0.0f) {
            t = (int)(this.startTime * 10.0f);
            this.entity.sprite.setVisible(t % 2 == 0);
            this.startTime -= this.app.getDeltaTime();
        }
        if (Math.abs(this.speed.y) > this.maxSpeed.y) {
            this.speed.y = Math.signum(this.speed.y) * this.maxSpeed.y;
        }
        if (App.isKeyDown(22)) {
            this.speed.x += this.acc.x;
            this.startTime = 0.0f;
        } else if (App.isKeyDown(21)) {
            this.speed.x += -this.acc.x;
            this.startTime = 0.0f;
        } else {
            this.speed.x = this.speed.x > 0.0f ? (this.speed.x -= this.acc.x) : (this.speed.x += this.acc.x);
            if (Math.abs(this.speed.x) - this.acc.x < this.acc.x) {
                this.speed.x = 0.0f;
            }
        }
        if (Math.abs(this.speed.x) > this.maxSpeed.x) {
            this.speed.x = Math.signum(this.speed.x) * this.maxSpeed.x;
        }
        this.entity.position.x += this.speed.x;
        if (this.entity.clipX()) {
            if (this.entity.clipperEntity != null) {
                if (this.entity.clipperEntity instanceof Entity_Box) {
                    this.entity.clipperEntity.position.x += this.speed.x;
                    if (this.boxSound == 0) {
                        this.game.playSound(8);
                    }
                    ++this.boxSound;
                    if (this.boxSound == 2) {
                        this.boxSound = 0;
                    }
                } else {
                    this.boxSound = 0;
                }
            }
            this.speed.x = 0.0f;
        }
        this.canJump = false;
        this.entity.position.y += this.speed.y;
        this.entity.clipperGrid = 0;
        boolean inAir = false;
        if (this.entity.clipY()) {
            if (this.speed.y < 0.0f) {
                boolean bl2 = this.canJump = !jumpButtonDown;
                if (!this.down) {
                    this.game.playSound(3);
                }
                this.down = true;
                this.walkTime += this.app.getDeltaTime();
            } else {
                inAir = true;
            }
            if (this.entity.clipperGrid == 3) {
                this.hit(1);
            }
            this.jumpCounter = 0;
            this.speed.y = 0.0f;
        } else {
            this.walkTime = 0.0f;
            this.down = false;
        }
        if (this.speed.x > 0.0f) {
            this.entity.sprite.setScale(1.0f, 1.0f);
        } else if (this.speed.x < 0.0f) {
            this.entity.sprite.setScale(-1.0f, 1.0f);
        }
        if (this.speed.y != 0.0f || inAir) {
            this.entity.sprite.setRegion(this.game.objectsTRegion[0][1]);
        } else if (this.speed.x != 0.0f) {
            this.entity.sprite.setRegion(this.walkAnim.getKeyFrame(this.walkTime, true));
        } else {
            this.entity.sprite.setRegion(this.game.objectsTRegion[0][0]);
        }
        if (this.game.grid.is((int)(this.entity.position.x / 16.0f), (int)((this.entity.position.y + 8.0f) / 16.0f), 8)) {
            this.entity.position.y = -1.0f;
        }
        if (this.entity.position.y < 0.0f) {
            this.died = true;
        }
        if (!this.entity.position.equals(this.entity.oldPosition) && this.oldWalkTime != this.walkTime) {
            this.stepTime += this.app.getDeltaTime();
            if (this.stepTime > 0.3f) {
                this.game.playSound(Math.random() > 0.5 ? 0 : 1);
                this.stepTime = 0.0f;
            }
        } else {
            this.stepTime = 0.15f;
        }
        this.oldWalkTime = this.walkTime;
    }

    public void hit(int power) {
        if (this.died) {
            return;
        }
        if (this.godTime > 0.0f) {
            return;
        }
        this.hearth -= power;
        if (this.hearth < 1) {
            this.hearth = 0;
            this.entity.block = false;
            this.entity.sprite.setLayer(1);
            this.entity.sprite.setVisible(true);
            this.died = true;
        }
        this.godTime = 2.0f;
        this.game.playSound(4);
    }

    public boolean isDied() {
        return this.died;
    }

    public void pickupHearth() {
        ++this.hearth;
    }

    public void pickupGold() {
        ++this.gold;
    }

    public void save() {
        this.app.config.setInt("live", this.live);
        this.app.config.setInt("hearth", this.hearth);
    }

    public void render(SpriteBatch batch) {
        this.font.draw(batch, "" + this.live, this.live < 10 ? 35 : 31, 17.0f);
        this.font.draw(batch, "" + this.hearth, this.hearth < 10 ? 101 : 97, 17.0f);
        this.font.draw(batch, "" + this.gold, this.gold < 10 ? 167 : 163, 17.0f);
        this.font.draw(batch, "" + this.game.getGoldCount(), this.game.getGoldCount() < 10 ? 205 : 201, 17.0f);
    }
}

