/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.math.Vector2;

public class Entity_Worm
extends GameEntity {
    public GameSprite sprite;
    private Vector2 pos1 = new Vector2();
    private Vector2 pos2 = new Vector2();
    private Animation anim;
    private float animTime;
    private boolean startDir = true;
    private float speed = 40.0f;

    public Entity_Worm(World w) {
        super(w);
        this.block = false;
    }

    public void setStartDir(boolean d) {
        this.startDir = d;
    }

    public void setSpeed(float s) {
        this.speed = s;
    }

    public void create() {
        this.sprite = new GameSprite(this.game.objectsTRegion[8][0]);
        this.sprite.setPosition(-1.0f, -16.0f);
        this.addSprite(this.sprite);
        this.anim = new Animation(0.15f, this.game.objectsTRegion[8][0], this.game.objectsTRegion[8][1], this.game.objectsTRegion[8][2], this.game.objectsTRegion[8][1]);
        this.animTime = (float)Math.random();
        int my = (int)(this.position.y / 16.0f);
        int mx = (int)(this.position.x / 16.0f);
        this.pos1.y = this.position.y;
        this.pos2.y = this.position.y;
        int px = mx;
        while (px < 25 && !this.world.grid.is(px, my, 1) && this.world.grid.is(px, my - 1, 1)) {
            ++px;
        }
        this.pos1.x = px * 16 - 16;
        px = mx;
        while (px > -1 && !this.world.grid.is(px, my, 1) && this.world.grid.is(px, my - 1, 1)) {
            --px;
        }
        this.pos2.x = px * 16 + 16;
    }

    @Override
    public void update() {
        super.update();
        if (this.getDistanceToPlayer() < 14.0f) {
            this.user.hit(1);
        }
        if (this.state == 0) {
            if (this.position.equals(this.pos1)) {
                this.moveTo(this.pos2, this.speed, 0.0f);
                this.sprite.setScale(1.0f, 1.0f);
            } else if (this.position.equals(this.pos2)) {
                this.moveTo(this.pos1, this.speed, 0.0f);
                this.sprite.setScale(-1.0f, 1.0f);
            } else if (this.startDir) {
                this.moveTo(this.pos1, this.speed, 0.0f);
                this.sprite.setScale(-1.0f, 1.0f);
            } else {
                this.moveTo(this.pos2, this.speed, 0.0f);
                this.sprite.setScale(1.0f, 1.0f);
            }
        }
        this.animTime += this.world.app.getDeltaTime();
        this.sprite.setRegion(this.anim.getKeyFrame(this.animTime, true));
    }
}

