/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.math.Vector2;

public class Entity_Bat
extends GameEntity {
    public GameSprite sprite;
    private Animation anim;
    private float animTime;
    Vector2 target = new Vector2();
    private float angle;
    private float angleTime;
    private float angleMaxTime;

    public Entity_Bat(World w) {
        super(w);
        this.block = false;
        this.moveClipUseGrid = 1;
        this.size.x = 14.0f;
        this.size.y = 14.0f;
        this.animTime = (float)Math.random();
        this.angleMaxTime = (float)Math.random();
    }

    public void create() {
        this.sprite = new GameSprite(this.game.objectsTRegion[5][0]);
        this.sprite.setPosition(-1.0f, -17.0f);
        this.addSprite(this.sprite);
        this.anim = new Animation(0.06f, this.game.objectsTRegion[5][0], this.game.objectsTRegion[5][1], this.game.objectsTRegion[5][2], this.game.objectsTRegion[5][1], this.game.objectsTRegion[5][0], this.game.objectsTRegion[5][3], this.game.objectsTRegion[5][4], this.game.objectsTRegion[5][3]);
    }

    @Override
    public void update() {
        this.animTime += this.world.app.getDeltaTime();
        this.sprite.setRegion(this.anim.getKeyFrame(this.animTime, true));
        super.update();
        if (this.user.isDied()) {
            return;
        }
        if (this.user.getEntity() == null) {
            return;
        }
        if (this.getDistanceToPlayer() < 16.0f) {
            this.user.hit(1);
        }
        this.target.set(this.user.getEntity().position);
        this.target.sub(this.position);
        this.target.nor();
        this.target.rotate(this.angle);
        this.angleTime += this.world.app.getDeltaTime();
        if (this.angleTime > this.angleMaxTime) {
            this.angle = Math.random() > 0.5 ? 30 : -30;
            this.angleTime = 0.0f;
            this.angleMaxTime = (float)Math.random();
        }
        this.position.x += this.target.x * 2.0f;
        this.clipX();
        this.position.y += this.target.y * 2.0f;
        this.clipY(false);
    }
}

