/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import javazoom.jl.decoder.OutputBuffer;

public final class SynthesisFilter {
    private float[] v1;
    private float[] v2;
    private float[] actual_v;
    private int actual_write_pos;
    private float[] samples;
    private int channel;
    private float scalefactor;
    private float[] _tmpOut = new float[32];
    private static final double MY_PI = Math.PI;
    private static final float cos1_64 = (float)(1.0 / (2.0 * Math.cos(0.04908738521234052)));
    private static final float cos3_64 = (float)(1.0 / (2.0 * Math.cos(0.14726215563702155)));
    private static final float cos5_64 = (float)(1.0 / (2.0 * Math.cos(0.2454369260617026)));
    private static final float cos7_64 = (float)(1.0 / (2.0 * Math.cos(0.3436116964863836)));
    private static final float cos9_64 = (float)(1.0 / (2.0 * Math.cos(0.44178646691106466)));
    private static final float cos11_64 = (float)(1.0 / (2.0 * Math.cos(0.5399612373357456)));
    private static final float cos13_64 = (float)(1.0 / (2.0 * Math.cos(0.6381360077604268)));
    private static final float cos15_64 = (float)(1.0 / (2.0 * Math.cos(0.7363107781851077)));
    private static final float cos17_64 = (float)(1.0 / (2.0 * Math.cos(0.8344855486097889)));
    private static final float cos19_64 = (float)(1.0 / (2.0 * Math.cos(0.9326603190344698)));
    private static final float cos21_64 = (float)(1.0 / (2.0 * Math.cos(1.030835089459151)));
    private static final float cos23_64 = (float)(1.0 / (2.0 * Math.cos(1.1290098598838318)));
    private static final float cos25_64 = (float)(1.0 / (2.0 * Math.cos(1.227184630308513)));
    private static final float cos27_64 = (float)(1.0 / (2.0 * Math.cos(1.325359400733194)));
    private static final float cos29_64 = (float)(1.0 / (2.0 * Math.cos(1.423534171157875)));
    private static final float cos31_64 = (float)(1.0 / (2.0 * Math.cos(1.521708941582556)));
    private static final float cos1_32 = (float)(1.0 / (2.0 * Math.cos(0.09817477042468103)));
    private static final float cos3_32 = (float)(1.0 / (2.0 * Math.cos(0.2945243112740431)));
    private static final float cos5_32 = (float)(1.0 / (2.0 * Math.cos(0.4908738521234052)));
    private static final float cos7_32 = (float)(1.0 / (2.0 * Math.cos(0.6872233929727672)));
    private static final float cos9_32 = (float)(1.0 / (2.0 * Math.cos(0.8835729338221293)));
    private static final float cos11_32 = (float)(1.0 / (2.0 * Math.cos(1.0799224746714913)));
    private static final float cos13_32 = (float)(1.0 / (2.0 * Math.cos(1.2762720155208536)));
    private static final float cos15_32 = (float)(1.0 / (2.0 * Math.cos(1.4726215563702154)));
    private static final float cos1_16 = (float)(1.0 / (2.0 * Math.cos(0.19634954084936207)));
    private static final float cos3_16 = (float)(1.0 / (2.0 * Math.cos(0.5890486225480862)));
    private static final float cos5_16 = (float)(1.0 / (2.0 * Math.cos(0.9817477042468103)));
    private static final float cos7_16 = (float)(1.0 / (2.0 * Math.cos(1.3744467859455345)));
    private static final float cos1_8 = (float)(1.0 / (2.0 * Math.cos(0.39269908169872414)));
    private static final float cos3_8 = (float)(1.0 / (2.0 * Math.cos(1.1780972450961724)));
    private static final float cos1_4 = (float)(1.0 / (2.0 * Math.cos(0.7853981633974483)));
    private static float[] d = null;
    private static float[][] d16 = null;

    public SynthesisFilter(int n, float f, float[] fArray) {
        if (d == null) {
            d = SynthesisFilter.load_d();
            d16 = SynthesisFilter.splitArray(d, 16);
        }
        this.v1 = new float[512];
        this.v2 = new float[512];
        this.samples = new float[32];
        this.channel = n;
        this.scalefactor = f;
        this.reset();
    }

    public void reset() {
        int n;
        for (n = 0; n < 512; ++n) {
            this.v2[n] = 0.0f;
            this.v1[n] = 0.0f;
        }
        for (n = 0; n < 32; ++n) {
            this.samples[n] = 0.0f;
        }
        this.actual_v = this.v1;
        this.actual_write_pos = 15;
    }

    public void input_sample(float f, int n) {
        this.samples[n] = f;
    }

    public void input_samples(float[] fArray) {
        for (int i = 31; i >= 0; --i) {
            this.samples[i] = fArray[i];
        }
    }

    private void compute_new_v() {
        float[] fArray = this.samples;
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        float f5 = fArray[4];
        float f6 = fArray[5];
        float f7 = fArray[6];
        float f8 = fArray[7];
        float f9 = fArray[8];
        float f10 = fArray[9];
        float f11 = fArray[10];
        float f12 = fArray[11];
        float f13 = fArray[12];
        float f14 = fArray[13];
        float f15 = fArray[14];
        float f16 = fArray[15];
        float f17 = fArray[16];
        float f18 = fArray[17];
        float f19 = fArray[18];
        float f20 = fArray[19];
        float f21 = fArray[20];
        float f22 = fArray[21];
        float f23 = fArray[22];
        float f24 = fArray[23];
        float f25 = fArray[24];
        float f26 = fArray[25];
        float f27 = fArray[26];
        float f28 = fArray[27];
        float f29 = fArray[28];
        float f30 = fArray[29];
        float f31 = fArray[30];
        float f32 = fArray[31];
        float f33 = f + f32;
        float f34 = f2 + f31;
        float f35 = f3 + f30;
        float f36 = f4 + f29;
        float f37 = f5 + f28;
        float f38 = f6 + f27;
        float f39 = f7 + f26;
        float f40 = f8 + f25;
        float f41 = f9 + f24;
        float f42 = f10 + f23;
        float f43 = f11 + f22;
        float f44 = f12 + f21;
        float f45 = f13 + f20;
        float f46 = f14 + f19;
        float f47 = f15 + f18;
        float f48 = f16 + f17;
        float f49 = f33 + f48;
        float f50 = f34 + f47;
        float f51 = f35 + f46;
        float f52 = f36 + f45;
        float f53 = f37 + f44;
        float f54 = f38 + f43;
        float f55 = f39 + f42;
        float f56 = f40 + f41;
        float f57 = (f33 - f48) * cos1_32;
        float f58 = (f34 - f47) * cos3_32;
        float f59 = (f35 - f46) * cos5_32;
        float f60 = (f36 - f45) * cos7_32;
        float f61 = (f37 - f44) * cos9_32;
        float f62 = (f38 - f43) * cos11_32;
        float f63 = (f39 - f42) * cos13_32;
        float f64 = (f40 - f41) * cos15_32;
        f33 = f49 + f56;
        f34 = f50 + f55;
        f35 = f51 + f54;
        f36 = f52 + f53;
        f37 = (f49 - f56) * cos1_16;
        f38 = (f50 - f55) * cos3_16;
        f39 = (f51 - f54) * cos5_16;
        f40 = (f52 - f53) * cos7_16;
        f41 = f57 + f64;
        f42 = f58 + f63;
        f43 = f59 + f62;
        f44 = f60 + f61;
        f45 = (f57 - f64) * cos1_16;
        f46 = (f58 - f63) * cos3_16;
        f47 = (f59 - f62) * cos5_16;
        f48 = (f60 - f61) * cos7_16;
        f49 = f33 + f36;
        f50 = f34 + f35;
        f51 = (f33 - f36) * cos1_8;
        f52 = (f34 - f35) * cos3_8;
        f53 = f37 + f40;
        f54 = f38 + f39;
        f55 = (f37 - f40) * cos1_8;
        f56 = (f38 - f39) * cos3_8;
        f57 = f41 + f44;
        f58 = f42 + f43;
        f59 = (f41 - f44) * cos1_8;
        f60 = (f42 - f43) * cos3_8;
        f61 = f45 + f48;
        f62 = f46 + f47;
        f63 = (f45 - f48) * cos1_8;
        f64 = (f46 - f47) * cos3_8;
        f33 = f49 + f50;
        f34 = (f49 - f50) * cos1_4;
        f35 = f51 + f52;
        f36 = (f51 - f52) * cos1_4;
        f37 = f53 + f54;
        f38 = (f53 - f54) * cos1_4;
        f39 = f55 + f56;
        f40 = (f55 - f56) * cos1_4;
        f41 = f57 + f58;
        f42 = (f57 - f58) * cos1_4;
        f43 = f59 + f60;
        f44 = (f59 - f60) * cos1_4;
        f45 = f61 + f62;
        f46 = (f61 - f62) * cos1_4;
        f47 = f63 + f64;
        f48 = (f63 - f64) * cos1_4;
        float f65 = f40;
        float f66 = f65 + f38;
        float f67 = -f66 - f39;
        float f68 = -f39 - f40 - f37;
        float f69 = f48;
        float f70 = f69 + f44;
        float f71 = f70 + f46;
        float f72 = f48 + f46 + f42;
        float f73 = -f72 - f47;
        float f74 = -f47 - f48 - f43 - f44;
        float f75 = f74 - f46;
        float f76 = -f47 - f48 - f45 - f41;
        float f77 = f74 - f45;
        float f78 = -f33;
        float f79 = f34;
        float f80 = f36;
        float f81 = -f80 - f35;
        f33 = (f - f32) * cos1_64;
        f34 = (f2 - f31) * cos3_64;
        f35 = (f3 - f30) * cos5_64;
        f36 = (f4 - f29) * cos7_64;
        f37 = (f5 - f28) * cos9_64;
        f38 = (f6 - f27) * cos11_64;
        f39 = (f7 - f26) * cos13_64;
        f40 = (f8 - f25) * cos15_64;
        f41 = (f9 - f24) * cos17_64;
        f42 = (f10 - f23) * cos19_64;
        f43 = (f11 - f22) * cos21_64;
        f44 = (f12 - f21) * cos23_64;
        f45 = (f13 - f20) * cos25_64;
        f46 = (f14 - f19) * cos27_64;
        f47 = (f15 - f18) * cos29_64;
        f48 = (f16 - f17) * cos31_64;
        f49 = f33 + f48;
        f50 = f34 + f47;
        f51 = f35 + f46;
        f52 = f36 + f45;
        f53 = f37 + f44;
        f54 = f38 + f43;
        f55 = f39 + f42;
        f56 = f40 + f41;
        f57 = (f33 - f48) * cos1_32;
        f58 = (f34 - f47) * cos3_32;
        f59 = (f35 - f46) * cos5_32;
        f60 = (f36 - f45) * cos7_32;
        f61 = (f37 - f44) * cos9_32;
        f62 = (f38 - f43) * cos11_32;
        f63 = (f39 - f42) * cos13_32;
        f64 = (f40 - f41) * cos15_32;
        f33 = f49 + f56;
        f34 = f50 + f55;
        f35 = f51 + f54;
        f36 = f52 + f53;
        f37 = (f49 - f56) * cos1_16;
        f38 = (f50 - f55) * cos3_16;
        f39 = (f51 - f54) * cos5_16;
        f40 = (f52 - f53) * cos7_16;
        f41 = f57 + f64;
        f42 = f58 + f63;
        f43 = f59 + f62;
        f44 = f60 + f61;
        f45 = (f57 - f64) * cos1_16;
        f46 = (f58 - f63) * cos3_16;
        f47 = (f59 - f62) * cos5_16;
        f48 = (f60 - f61) * cos7_16;
        f49 = f33 + f36;
        f50 = f34 + f35;
        f51 = (f33 - f36) * cos1_8;
        f52 = (f34 - f35) * cos3_8;
        f53 = f37 + f40;
        f54 = f38 + f39;
        f55 = (f37 - f40) * cos1_8;
        f56 = (f38 - f39) * cos3_8;
        f57 = f41 + f44;
        f58 = f42 + f43;
        f59 = (f41 - f44) * cos1_8;
        f60 = (f42 - f43) * cos3_8;
        f61 = f45 + f48;
        f62 = f46 + f47;
        f63 = (f45 - f48) * cos1_8;
        f64 = (f46 - f47) * cos3_8;
        f33 = f49 + f50;
        f34 = (f49 - f50) * cos1_4;
        f35 = f51 + f52;
        f36 = (f51 - f52) * cos1_4;
        f37 = f53 + f54;
        f38 = (f53 - f54) * cos1_4;
        f39 = f55 + f56;
        f40 = (f55 - f56) * cos1_4;
        f41 = f57 + f58;
        f42 = (f57 - f58) * cos1_4;
        f43 = f59 + f60;
        f44 = (f59 - f60) * cos1_4;
        f45 = f61 + f62;
        f46 = (f61 - f62) * cos1_4;
        f47 = f63 + f64;
        float f82 = f48 = (f63 - f64) * cos1_4;
        float f83 = f82 + f40;
        float f84 = f83 + f44;
        float f85 = f84 + f38 + f46;
        float f86 = f48 + f44 + f36;
        float f87 = f86 + f46;
        f74 = f46 + f48 + f42;
        float f88 = f74 + f34;
        float f89 = -f88 - f47;
        float f90 = f74 + f38 + f40;
        float f91 = -f90 - f39 - f47;
        f74 = -f43 - f44 - f47 - f48;
        float f92 = f74 - f46 - f35 - f36;
        float f93 = f74 - f46 - f38 - f39 - f40;
        float f94 = f74 - f45 - f35 - f36;
        float f95 = f37 + f39 + f40;
        float f96 = f74 - f45 - f95;
        f74 = -f41 - f45 - f47 - f48;
        float f97 = f74 - f33;
        float f98 = f74 - f95;
        float[] fArray2 = this.actual_v;
        int n = this.actual_write_pos;
        fArray2[0 + n] = f79;
        fArray2[16 + n] = f88;
        fArray2[32 + n] = f72;
        fArray2[48 + n] = f90;
        fArray2[64 + n] = f66;
        fArray2[80 + n] = f85;
        fArray2[96 + n] = f71;
        fArray2[112 + n] = f87;
        fArray2[128 + n] = f80;
        fArray2[144 + n] = f86;
        fArray2[160 + n] = f70;
        fArray2[176 + n] = f84;
        fArray2[192 + n] = f65;
        fArray2[208 + n] = f83;
        fArray2[224 + n] = f69;
        fArray2[240 + n] = f82;
        fArray2[256 + n] = 0.0f;
        fArray2[272 + n] = -f82;
        fArray2[288 + n] = -f69;
        fArray2[304 + n] = -f83;
        fArray2[320 + n] = -f65;
        fArray2[336 + n] = -f84;
        fArray2[352 + n] = -f70;
        fArray2[368 + n] = -f86;
        fArray2[384 + n] = -f80;
        fArray2[400 + n] = -f87;
        fArray2[416 + n] = -f71;
        fArray2[432 + n] = -f85;
        fArray2[448 + n] = -f66;
        fArray2[464 + n] = -f90;
        fArray2[480 + n] = -f72;
        fArray2[496 + n] = -f88;
        fArray2 = this.actual_v == this.v1 ? this.v2 : this.v1;
        fArray2[0 + n] = -f79;
        fArray2[16 + n] = f89;
        fArray2[32 + n] = f73;
        fArray2[48 + n] = f91;
        fArray2[64 + n] = f67;
        fArray2[80 + n] = f93;
        fArray2[96 + n] = f75;
        fArray2[112 + n] = f92;
        fArray2[128 + n] = f81;
        fArray2[144 + n] = f94;
        fArray2[160 + n] = f77;
        fArray2[176 + n] = f96;
        fArray2[192 + n] = f68;
        fArray2[208 + n] = f98;
        fArray2[224 + n] = f76;
        fArray2[240 + n] = f97;
        fArray2[256 + n] = f78;
        fArray2[272 + n] = f97;
        fArray2[288 + n] = f76;
        fArray2[304 + n] = f98;
        fArray2[320 + n] = f68;
        fArray2[336 + n] = f96;
        fArray2[352 + n] = f77;
        fArray2[368 + n] = f94;
        fArray2[384 + n] = f81;
        fArray2[400 + n] = f92;
        fArray2[416 + n] = f75;
        fArray2[432 + n] = f93;
        fArray2[448 + n] = f67;
        fArray2[464 + n] = f91;
        fArray2[480 + n] = f73;
        fArray2[496 + n] = f89;
    }

    private void compute_pcm_samples0(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[0 + n] * fArray3[0] + fArray[15 + n] * fArray3[1] + fArray[14 + n] * fArray3[2] + fArray[13 + n] * fArray3[3] + fArray[12 + n] * fArray3[4] + fArray[11 + n] * fArray3[5] + fArray[10 + n] * fArray3[6] + fArray[9 + n] * fArray3[7] + fArray[8 + n] * fArray3[8] + fArray[7 + n] * fArray3[9] + fArray[6 + n] * fArray3[10] + fArray[5 + n] * fArray3[11] + fArray[4 + n] * fArray3[12] + fArray[3 + n] * fArray3[13] + fArray[2 + n] * fArray3[14] + fArray[1 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples1(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[1 + n] * fArray3[0] + fArray[0 + n] * fArray3[1] + fArray[15 + n] * fArray3[2] + fArray[14 + n] * fArray3[3] + fArray[13 + n] * fArray3[4] + fArray[12 + n] * fArray3[5] + fArray[11 + n] * fArray3[6] + fArray[10 + n] * fArray3[7] + fArray[9 + n] * fArray3[8] + fArray[8 + n] * fArray3[9] + fArray[7 + n] * fArray3[10] + fArray[6 + n] * fArray3[11] + fArray[5 + n] * fArray3[12] + fArray[4 + n] * fArray3[13] + fArray[3 + n] * fArray3[14] + fArray[2 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples2(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[2 + n] * fArray3[0] + fArray[1 + n] * fArray3[1] + fArray[0 + n] * fArray3[2] + fArray[15 + n] * fArray3[3] + fArray[14 + n] * fArray3[4] + fArray[13 + n] * fArray3[5] + fArray[12 + n] * fArray3[6] + fArray[11 + n] * fArray3[7] + fArray[10 + n] * fArray3[8] + fArray[9 + n] * fArray3[9] + fArray[8 + n] * fArray3[10] + fArray[7 + n] * fArray3[11] + fArray[6 + n] * fArray3[12] + fArray[5 + n] * fArray3[13] + fArray[4 + n] * fArray3[14] + fArray[3 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples3(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[3 + n] * fArray3[0] + fArray[2 + n] * fArray3[1] + fArray[1 + n] * fArray3[2] + fArray[0 + n] * fArray3[3] + fArray[15 + n] * fArray3[4] + fArray[14 + n] * fArray3[5] + fArray[13 + n] * fArray3[6] + fArray[12 + n] * fArray3[7] + fArray[11 + n] * fArray3[8] + fArray[10 + n] * fArray3[9] + fArray[9 + n] * fArray3[10] + fArray[8 + n] * fArray3[11] + fArray[7 + n] * fArray3[12] + fArray[6 + n] * fArray3[13] + fArray[5 + n] * fArray3[14] + fArray[4 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples4(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[4 + n] * fArray3[0] + fArray[3 + n] * fArray3[1] + fArray[2 + n] * fArray3[2] + fArray[1 + n] * fArray3[3] + fArray[0 + n] * fArray3[4] + fArray[15 + n] * fArray3[5] + fArray[14 + n] * fArray3[6] + fArray[13 + n] * fArray3[7] + fArray[12 + n] * fArray3[8] + fArray[11 + n] * fArray3[9] + fArray[10 + n] * fArray3[10] + fArray[9 + n] * fArray3[11] + fArray[8 + n] * fArray3[12] + fArray[7 + n] * fArray3[13] + fArray[6 + n] * fArray3[14] + fArray[5 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples5(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[5 + n] * fArray3[0] + fArray[4 + n] * fArray3[1] + fArray[3 + n] * fArray3[2] + fArray[2 + n] * fArray3[3] + fArray[1 + n] * fArray3[4] + fArray[0 + n] * fArray3[5] + fArray[15 + n] * fArray3[6] + fArray[14 + n] * fArray3[7] + fArray[13 + n] * fArray3[8] + fArray[12 + n] * fArray3[9] + fArray[11 + n] * fArray3[10] + fArray[10 + n] * fArray3[11] + fArray[9 + n] * fArray3[12] + fArray[8 + n] * fArray3[13] + fArray[7 + n] * fArray3[14] + fArray[6 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples6(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[6 + n] * fArray3[0] + fArray[5 + n] * fArray3[1] + fArray[4 + n] * fArray3[2] + fArray[3 + n] * fArray3[3] + fArray[2 + n] * fArray3[4] + fArray[1 + n] * fArray3[5] + fArray[0 + n] * fArray3[6] + fArray[15 + n] * fArray3[7] + fArray[14 + n] * fArray3[8] + fArray[13 + n] * fArray3[9] + fArray[12 + n] * fArray3[10] + fArray[11 + n] * fArray3[11] + fArray[10 + n] * fArray3[12] + fArray[9 + n] * fArray3[13] + fArray[8 + n] * fArray3[14] + fArray[7 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples7(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[7 + n] * fArray3[0] + fArray[6 + n] * fArray3[1] + fArray[5 + n] * fArray3[2] + fArray[4 + n] * fArray3[3] + fArray[3 + n] * fArray3[4] + fArray[2 + n] * fArray3[5] + fArray[1 + n] * fArray3[6] + fArray[0 + n] * fArray3[7] + fArray[15 + n] * fArray3[8] + fArray[14 + n] * fArray3[9] + fArray[13 + n] * fArray3[10] + fArray[12 + n] * fArray3[11] + fArray[11 + n] * fArray3[12] + fArray[10 + n] * fArray3[13] + fArray[9 + n] * fArray3[14] + fArray[8 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples8(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[8 + n] * fArray3[0] + fArray[7 + n] * fArray3[1] + fArray[6 + n] * fArray3[2] + fArray[5 + n] * fArray3[3] + fArray[4 + n] * fArray3[4] + fArray[3 + n] * fArray3[5] + fArray[2 + n] * fArray3[6] + fArray[1 + n] * fArray3[7] + fArray[0 + n] * fArray3[8] + fArray[15 + n] * fArray3[9] + fArray[14 + n] * fArray3[10] + fArray[13 + n] * fArray3[11] + fArray[12 + n] * fArray3[12] + fArray[11 + n] * fArray3[13] + fArray[10 + n] * fArray3[14] + fArray[9 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples9(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[9 + n] * fArray3[0] + fArray[8 + n] * fArray3[1] + fArray[7 + n] * fArray3[2] + fArray[6 + n] * fArray3[3] + fArray[5 + n] * fArray3[4] + fArray[4 + n] * fArray3[5] + fArray[3 + n] * fArray3[6] + fArray[2 + n] * fArray3[7] + fArray[1 + n] * fArray3[8] + fArray[0 + n] * fArray3[9] + fArray[15 + n] * fArray3[10] + fArray[14 + n] * fArray3[11] + fArray[13 + n] * fArray3[12] + fArray[12 + n] * fArray3[13] + fArray[11 + n] * fArray3[14] + fArray[10 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples10(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[10 + n] * fArray3[0] + fArray[9 + n] * fArray3[1] + fArray[8 + n] * fArray3[2] + fArray[7 + n] * fArray3[3] + fArray[6 + n] * fArray3[4] + fArray[5 + n] * fArray3[5] + fArray[4 + n] * fArray3[6] + fArray[3 + n] * fArray3[7] + fArray[2 + n] * fArray3[8] + fArray[1 + n] * fArray3[9] + fArray[0 + n] * fArray3[10] + fArray[15 + n] * fArray3[11] + fArray[14 + n] * fArray3[12] + fArray[13 + n] * fArray3[13] + fArray[12 + n] * fArray3[14] + fArray[11 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples11(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[11 + n] * fArray3[0] + fArray[10 + n] * fArray3[1] + fArray[9 + n] * fArray3[2] + fArray[8 + n] * fArray3[3] + fArray[7 + n] * fArray3[4] + fArray[6 + n] * fArray3[5] + fArray[5 + n] * fArray3[6] + fArray[4 + n] * fArray3[7] + fArray[3 + n] * fArray3[8] + fArray[2 + n] * fArray3[9] + fArray[1 + n] * fArray3[10] + fArray[0 + n] * fArray3[11] + fArray[15 + n] * fArray3[12] + fArray[14 + n] * fArray3[13] + fArray[13 + n] * fArray3[14] + fArray[12 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples12(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[12 + n] * fArray3[0] + fArray[11 + n] * fArray3[1] + fArray[10 + n] * fArray3[2] + fArray[9 + n] * fArray3[3] + fArray[8 + n] * fArray3[4] + fArray[7 + n] * fArray3[5] + fArray[6 + n] * fArray3[6] + fArray[5 + n] * fArray3[7] + fArray[4 + n] * fArray3[8] + fArray[3 + n] * fArray3[9] + fArray[2 + n] * fArray3[10] + fArray[1 + n] * fArray3[11] + fArray[0 + n] * fArray3[12] + fArray[15 + n] * fArray3[13] + fArray[14 + n] * fArray3[14] + fArray[13 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples13(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[13 + n] * fArray3[0] + fArray[12 + n] * fArray3[1] + fArray[11 + n] * fArray3[2] + fArray[10 + n] * fArray3[3] + fArray[9 + n] * fArray3[4] + fArray[8 + n] * fArray3[5] + fArray[7 + n] * fArray3[6] + fArray[6 + n] * fArray3[7] + fArray[5 + n] * fArray3[8] + fArray[4 + n] * fArray3[9] + fArray[3 + n] * fArray3[10] + fArray[2 + n] * fArray3[11] + fArray[1 + n] * fArray3[12] + fArray[0 + n] * fArray3[13] + fArray[15 + n] * fArray3[14] + fArray[14 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples14(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[14 + n] * fArray3[0] + fArray[13 + n] * fArray3[1] + fArray[12 + n] * fArray3[2] + fArray[11 + n] * fArray3[3] + fArray[10 + n] * fArray3[4] + fArray[9 + n] * fArray3[5] + fArray[8 + n] * fArray3[6] + fArray[7 + n] * fArray3[7] + fArray[6 + n] * fArray3[8] + fArray[5 + n] * fArray3[9] + fArray[4 + n] * fArray3[10] + fArray[3 + n] * fArray3[11] + fArray[2 + n] * fArray3[12] + fArray[1 + n] * fArray3[13] + fArray[0 + n] * fArray3[14] + fArray[15 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples15(OutputBuffer outputBuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            float f;
            float[] fArray3 = d16[i];
            fArray2[i] = f = (fArray[15 + n] * fArray3[0] + fArray[14 + n] * fArray3[1] + fArray[13 + n] * fArray3[2] + fArray[12 + n] * fArray3[3] + fArray[11 + n] * fArray3[4] + fArray[10 + n] * fArray3[5] + fArray[9 + n] * fArray3[6] + fArray[8 + n] * fArray3[7] + fArray[7 + n] * fArray3[8] + fArray[6 + n] * fArray3[9] + fArray[5 + n] * fArray3[10] + fArray[4 + n] * fArray3[11] + fArray[3 + n] * fArray3[12] + fArray[2 + n] * fArray3[13] + fArray[1 + n] * fArray3[14] + fArray[0 + n] * fArray3[15]) * this.scalefactor;
            n += 16;
        }
    }

    private void compute_pcm_samples(OutputBuffer outputBuffer) {
        switch (this.actual_write_pos) {
            case 0: {
                this.compute_pcm_samples0(outputBuffer);
                break;
            }
            case 1: {
                this.compute_pcm_samples1(outputBuffer);
                break;
            }
            case 2: {
                this.compute_pcm_samples2(outputBuffer);
                break;
            }
            case 3: {
                this.compute_pcm_samples3(outputBuffer);
                break;
            }
            case 4: {
                this.compute_pcm_samples4(outputBuffer);
                break;
            }
            case 5: {
                this.compute_pcm_samples5(outputBuffer);
                break;
            }
            case 6: {
                this.compute_pcm_samples6(outputBuffer);
                break;
            }
            case 7: {
                this.compute_pcm_samples7(outputBuffer);
                break;
            }
            case 8: {
                this.compute_pcm_samples8(outputBuffer);
                break;
            }
            case 9: {
                this.compute_pcm_samples9(outputBuffer);
                break;
            }
            case 10: {
                this.compute_pcm_samples10(outputBuffer);
                break;
            }
            case 11: {
                this.compute_pcm_samples11(outputBuffer);
                break;
            }
            case 12: {
                this.compute_pcm_samples12(outputBuffer);
                break;
            }
            case 13: {
                this.compute_pcm_samples13(outputBuffer);
                break;
            }
            case 14: {
                this.compute_pcm_samples14(outputBuffer);
                break;
            }
            case 15: {
                this.compute_pcm_samples15(outputBuffer);
            }
        }
        if (outputBuffer != null) {
            outputBuffer.appendSamples(this.channel, this._tmpOut);
        }
    }

    public void calculate_pcm_samples(OutputBuffer outputBuffer) {
        this.compute_new_v();
        this.compute_pcm_samples(outputBuffer);
        this.actual_write_pos = this.actual_write_pos + 1 & 0xF;
        this.actual_v = this.actual_v == this.v1 ? this.v2 : this.v1;
        for (int i = 0; i < 32; ++i) {
            this.samples[i] = 0.0f;
        }
    }

    private static float[] load_d() {
        try {
            Class<Float> clazz = Float.TYPE;
            Object object = SynthesisFilter.deserializeArray(SynthesisFilter.class.getResourceAsStream("/sfd.ser"), clazz, 512);
            return (float[])object;
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError(iOException);
        }
    }

    private static Object deserializeArray(InputStream inputStream, Class clazz, int n) throws IOException {
        int n2;
        if (clazz == null) {
            throw new NullPointerException("elemType");
        }
        if (n < -1) {
            throw new IllegalArgumentException("length");
        }
        Object object = SynthesisFilter.deserialize(inputStream);
        Class<?> clazz2 = object.getClass();
        if (!clazz2.isArray()) {
            throw new InvalidObjectException("object is not an array");
        }
        Class<?> clazz3 = clazz2.getComponentType();
        if (clazz3 != clazz) {
            throw new InvalidObjectException("unexpected array component type");
        }
        if (n != -1 && (n2 = Array.getLength(object)) != n) {
            throw new InvalidObjectException("array length mismatch");
        }
        return object;
    }

    public static Object deserialize(InputStream inputStream) throws IOException {
        Object object;
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        try {
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidClassException(classNotFoundException.toString());
        }
        return object;
    }

    private static float[][] splitArray(float[] fArray, int n) {
        int n2 = fArray.length / n;
        float[][] fArrayArray = new float[n2][];
        for (int i = 0; i < n2; ++i) {
            fArrayArray[i] = SynthesisFilter.subArray(fArray, i * n, n);
        }
        return fArrayArray;
    }

    private static float[] subArray(float[] fArray, int n, int n2) {
        if (n + n2 > fArray.length) {
            n2 = fArray.length - n;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        float[] fArray2 = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray2[i] = fArray[n + i];
        }
        return fArray2;
    }
}

