/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui.tablelayout;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.Table;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.TableLayout;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.esotericsoftware.tablelayout.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class LibgdxToolkit
extends Toolkit<Actor, Table, TableLayout> {
    public static LibgdxToolkit instance;
    static boolean drawDebug;

    @Override
    public Actor wrap(TableLayout layout, Object object) {
        if (object instanceof String) {
            if (layout.skin == null) {
                throw new IllegalStateException("Label cannot be created, no skin has been set.");
            }
            return new Label((CharSequence)((String)object), layout.skin);
        }
        if (object == null) {
            return new Actor(){
                {
                    this.visible = false;
                }

                @Override
                public void draw(SpriteBatch batch, float parentAlpha) {
                }

                @Override
                public Actor hit(float x, float y) {
                    return null;
                }
            };
        }
        return (Actor)super.wrap(layout, object);
    }

    @Override
    public Actor newWidget(TableLayout layout, String className) {
        try {
            return (Actor)super.newWidget(layout, className);
        }
        catch (RuntimeException ex) {
            Skin skin = layout.skin;
            if (skin != null) {
                if (skin.hasResource(className, TextureRegion.class)) {
                    return new Image(skin.getRegion(className));
                }
                if (skin.hasResource(className, NinePatch.class)) {
                    return new Image(skin.getPatch(className));
                }
            }
            if (layout.assetManager != null && layout.assetManager.isLoaded(className, Texture.class)) {
                return new Image(new TextureRegion(layout.assetManager.get(className, Texture.class)));
            }
            throw ex;
        }
    }

    @Override
    protected Actor newInstance(TableLayout layout, String className) throws Exception {
        try {
            return (Actor)super.newInstance(layout, className);
        }
        catch (Exception ex) {
            if (layout.skin != null) {
                try {
                    return (Actor)Class.forName(className).getConstructor(Skin.class).newInstance(layout.skin);
                }
                catch (InvocationTargetException ex2) {
                    throw new InvocationTargetException(ex2, "Error constructing instance of class: " + className);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    @Override
    public void setProperty(TableLayout layout, Actor object, String name, List<String> values) {
        try {
            super.setProperty(layout, object, name, values);
        }
        catch (RuntimeException ex) {
            if (layout.skin != null && values.size() == 1 && name.equalsIgnoreCase("style")) {
                try {
                    String styleName = values.get(0);
                    Class<?> styleClass = Class.forName(object.getClass().getName() + "$" + object.getClass().getSimpleName() + "Style");
                    if (layout.skin.hasStyle(styleName, styleClass)) {
                        try {
                            Method setStyleMethod = object.getClass().getMethod("setStyle", styleClass);
                            setStyleMethod.invoke((Object)object, layout.skin.getStyle(styleName, styleClass));
                            return;
                        }
                        catch (Exception ex2) {
                            throw new GdxRuntimeException("Unable to set style: " + styleName, ex2);
                        }
                    }
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    @Override
    protected Object convertType(TableLayout layout, Object parentObject, Class memberType, String memberName, String value) {
        if (layout.skin != null) {
            if (memberType == NinePatch.class) {
                if (layout.skin.hasResource(value, NinePatch.class)) {
                    return layout.skin.getPatch(value);
                }
            } else if (memberType == TextureRegion.class && layout.skin.hasResource(value, TextureRegion.class)) {
                return layout.skin.getRegion(value);
            }
        }
        if (layout.assetManager != null) {
            if (memberType == NinePatch.class) {
                if (layout.assetManager.isLoaded(value, Texture.class)) {
                    return new NinePatch(new TextureRegion(layout.assetManager.get(value, Texture.class)));
                }
            } else if (memberType == Texture.class) {
                if (layout.assetManager.isLoaded(value, Texture.class)) {
                    return layout.assetManager.get(value, Texture.class);
                }
            } else if (memberType == TextureRegion.class && layout.assetManager.isLoaded(value, Texture.class)) {
                return new TextureRegion(layout.assetManager.get(value, Texture.class));
            }
        }
        return super.convertType(layout, parentObject, memberType, memberName, value);
    }

    @Override
    public Table newTable(Table parent) {
        Table table = new Table();
        TableLayout layout = parent.getTableLayout();
        table.setSkin(layout.skin);
        table.setAssetManager(layout.assetManager);
        return table;
    }

    @Override
    public TableLayout getLayout(Table table) {
        return table.getTableLayout();
    }

    @Override
    public Actor newStack() {
        return new Stack();
    }

    @Override
    public void addChild(Actor parent, Actor child, String layoutString) {
        if (child.parent != null) {
            child.remove();
        }
        try {
            parent.getClass().getMethod("setWidget", Actor.class).invoke((Object)parent, child);
            return;
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error calling setWidget.", ex);
        }
        catch (Exception ignored) {
            ((Group)parent).addActor(child);
            return;
        }
    }

    @Override
    public void removeChild(Actor parent, Actor child) {
        ((Group)parent).removeActor(child);
    }

    @Override
    public int getMinWidth(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getMinWidth();
        }
        return (int)actor.width;
    }

    @Override
    public int getMinHeight(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getMinHeight();
        }
        return (int)actor.height;
    }

    @Override
    public int getPrefWidth(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getPrefWidth();
        }
        return (int)actor.width;
    }

    @Override
    public int getPrefHeight(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getPrefHeight();
        }
        return (int)actor.height;
    }

    @Override
    public int getMaxWidth(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getMaxWidth();
        }
        return 0;
    }

    @Override
    public int getMaxHeight(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getMaxHeight();
        }
        return 0;
    }

    @Override
    public void clearDebugRectangles(TableLayout layout) {
        if (layout.debugRects != null) {
            layout.debugRects.clear();
        }
    }

    @Override
    public void addDebugRectangle(TableLayout layout, int type, int x, int y, int w, int h) {
        drawDebug = true;
        if (layout.debugRects == null) {
            layout.debugRects = new Array();
        }
        layout.debugRects.add(new DebugRect(type, x, (int)(((Table)layout.getTable()).height - (float)y), w, h));
    }

    static {
        LibgdxToolkit.addClassPrefix("com.badlogic.gdx.scenes.scene2d.");
        LibgdxToolkit.addClassPrefix("com.badlogic.gdx.scenes.scene2d.ui.");
        instance = new LibgdxToolkit();
    }

    static class DebugRect
    extends Rectangle {
        final int type;

        public DebugRect(int type, int x, int y, int width, int height) {
            super(x, y, width, height);
            this.type = type;
        }
    }
}

