/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;

public abstract class Widget
extends Actor
implements Layout {
    private boolean needsLayout = true;
    private boolean fillParent;

    public Widget() {
        super(null);
    }

    public Widget(String name) {
        super(name);
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    @Override
    public float getPrefWidth() {
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        return 0.0f;
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }

    @Override
    public void invalidate() {
        this.needsLayout = true;
    }

    @Override
    public void validate() {
        if (this.fillParent && this.parent != null) {
            float parentHeight;
            float parentWidth;
            if (this.stage != null && this.parent == this.stage.getRoot()) {
                parentWidth = this.stage.width();
                parentHeight = this.stage.height();
            } else {
                parentWidth = this.parent.width;
                parentHeight = this.parent.height;
            }
            if (this.width != parentWidth || this.height != parentHeight) {
                this.width = parentWidth;
                this.height = parentHeight;
                this.invalidate();
            }
        }
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        this.layout();
    }

    public boolean needsLayout() {
        return this.needsLayout;
    }

    @Override
    public void invalidateHierarchy() {
        this.invalidate();
        if (this.parent instanceof Layout) {
            ((Layout)((Object)this.parent)).invalidateHierarchy();
        }
    }

    @Override
    public void pack() {
        float newWidth = this.getPrefWidth();
        float newHeight = this.getPrefHeight();
        if (newWidth != this.width || newHeight != this.height) {
            this.width = newWidth;
            this.height = newHeight;
            this.invalidate();
            this.validate();
        }
    }

    @Override
    public void setFillParent(boolean fillParent) {
        this.fillParent = fillParent;
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        this.validate();
    }

    @Override
    public Actor hit(float x, float y) {
        return x > 0.0f && x < this.width && y > 0.0f && y < this.height ? this : null;
    }

    @Override
    public void layout() {
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        return false;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
    }

    public static void toScreenCoordinates(Actor actor, Vector2 point) {
        point.x += actor.x;
        point.y += actor.y;
        Group parent = actor.parent;
        while (parent != null) {
            if (parent instanceof Group) {
                point.x += parent.x;
                point.y += parent.y;
            }
            parent = parent.parent;
        }
    }
}

