/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class SplitPane
extends WidgetGroup {
    private SplitPaneStyle style;
    private Actor firstWidget;
    private Actor secondWidget;
    private boolean vertical;
    private float splitAmount = 0.5f;
    private float minAmount;
    private float maxAmount = 1.0f;
    private float oldSplitAmount;
    private boolean touchDrag;
    private Rectangle firstWidgetBounds = new Rectangle();
    private Rectangle secondWidgetBounds = new Rectangle();
    private Rectangle handleBounds = new Rectangle();
    private Rectangle firstScissors = new Rectangle();
    private Rectangle secondScissors = new Rectangle();
    private Vector2 lastPoint = new Vector2();
    private Vector2 handlePosition = new Vector2();

    public SplitPane(Skin skin) {
        this(null, null, false, skin);
    }

    public SplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, Skin skin) {
        this(firstWidget, secondWidget, vertical, skin.getStyle("default-horizontal", SplitPaneStyle.class), null);
    }

    public SplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, SplitPaneStyle style) {
        this(firstWidget, secondWidget, vertical, style, null);
    }

    public SplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, SplitPaneStyle style, String name) {
        super(name);
        this.firstWidget = firstWidget;
        this.secondWidget = secondWidget;
        this.vertical = vertical;
        this.setStyle(style);
        this.setFirstWidget(firstWidget);
        this.setSecondWidget(secondWidget);
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public void setStyle(SplitPaneStyle style) {
        this.style = style;
        this.invalidateHierarchy();
    }

    public SplitPaneStyle getStyle() {
        return this.style;
    }

    @Override
    public void layout() {
        Layout layout;
        if (!this.vertical) {
            this.calculateHorizBoundsAndPositions();
        } else {
            this.calculateVertBoundsAndPositions();
        }
        if (this.firstWidget != null && this.firstWidget.width != this.firstWidgetBounds.width || this.firstWidget.height != this.firstWidgetBounds.height) {
            this.firstWidget.x = this.firstWidgetBounds.x;
            this.firstWidget.y = this.firstWidgetBounds.y;
            this.firstWidget.width = this.firstWidgetBounds.width;
            this.firstWidget.height = this.firstWidgetBounds.height;
            if (this.firstWidget instanceof Layout) {
                layout = (Layout)((Object)this.firstWidget);
                layout.invalidate();
                layout.validate();
            }
        }
        if (this.secondWidget != null && this.secondWidget.width != this.secondWidgetBounds.width || this.secondWidget.height != this.secondWidgetBounds.height) {
            this.secondWidget.x = this.secondWidgetBounds.x;
            this.secondWidget.y = this.secondWidgetBounds.y;
            this.secondWidget.width = this.secondWidgetBounds.width;
            this.secondWidget.height = this.secondWidgetBounds.height;
            if (this.secondWidget instanceof Layout) {
                layout = (Layout)((Object)this.secondWidget);
                layout.invalidate();
                layout.validate();
            }
        }
    }

    @Override
    public float getPrefWidth() {
        float width = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getPrefWidth() : this.firstWidget.width;
        width += this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getPrefWidth() : this.secondWidget.width;
        if (!this.vertical) {
            width += this.style.handle.getTotalWidth();
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        float height = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getPrefHeight() : this.firstWidget.height;
        height += this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getPrefHeight() : this.secondWidget.height;
        if (this.vertical) {
            height += this.style.handle.getTotalHeight();
        }
        return height;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    private void calculateHorizBoundsAndPositions() {
        NinePatch handle = this.style.handle;
        float availWidth = this.width - handle.getTotalWidth();
        float leftAreaWidth = (int)(availWidth * this.splitAmount);
        float rightAreaWidth = availWidth - leftAreaWidth;
        float handleWidth = handle.getTotalWidth();
        this.firstWidgetBounds.set(0.0f, 0.0f, leftAreaWidth, this.height);
        this.secondWidgetBounds.set(leftAreaWidth + handleWidth, 0.0f, rightAreaWidth, this.height);
        this.handleBounds.set(leftAreaWidth, 0.0f, handleWidth, this.height);
    }

    private void calculateVertBoundsAndPositions() {
        NinePatch handle = this.style.handle;
        float availHeight = this.height - handle.getTotalHeight();
        float topAreaHeight = (int)(availHeight * this.splitAmount);
        float bottomAreaHeight = availHeight - topAreaHeight;
        float handleHeight = handle.getTotalHeight();
        this.firstWidgetBounds.set(0.0f, this.height - topAreaHeight, this.width, topAreaHeight);
        this.secondWidgetBounds.set(0.0f, 0.0f, this.width, bottomAreaHeight);
        this.handleBounds.set(0.0f, bottomAreaHeight, this.width, handleHeight);
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        this.validate();
        NinePatch handle = this.style.handle;
        this.applyTransform(batch);
        Matrix4 transform = batch.getTransformMatrix();
        if (this.firstWidget != null) {
            ScissorStack.calculateScissors(this.stage.getCamera(), transform, this.firstWidgetBounds, this.firstScissors);
            if (ScissorStack.pushScissors(this.firstScissors)) {
                this.drawChild(this.firstWidget, batch, parentAlpha);
                ScissorStack.popScissors();
            }
        }
        if (this.secondWidget != null) {
            ScissorStack.calculateScissors(this.stage.getCamera(), transform, this.secondWidgetBounds, this.secondScissors);
            if (ScissorStack.pushScissors(this.secondScissors)) {
                this.drawChild(this.secondWidget, batch, parentAlpha);
                ScissorStack.popScissors();
            }
        }
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a);
        handle.draw(batch, this.handleBounds.x, this.handleBounds.y, this.handleBounds.width, this.handleBounds.height);
        this.resetTransform(batch);
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        if (this.handleBounds.contains(x, y)) {
            this.touchDrag = true;
            this.lastPoint.set(x, y);
            this.handlePosition.set(this.handleBounds.x, this.handleBounds.y);
            return true;
        }
        return super.touchDown(x, y, pointer);
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        if (this.touchDrag) {
            this.touchDrag = false;
        } else {
            super.touchUp(x, y, pointer);
        }
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        if (!this.touchDrag) {
            super.touchDragged(x, y, pointer);
            return;
        }
        NinePatch handle = this.style.handle;
        if (!this.vertical) {
            float dragX;
            float delta = x - this.lastPoint.x;
            float availWidth = this.width - handle.getTotalWidth();
            this.handlePosition.x = dragX = this.handlePosition.x + delta;
            dragX = Math.max(0.0f, dragX);
            dragX = Math.min(availWidth, dragX);
            this.splitAmount = dragX / availWidth;
            if (this.splitAmount < this.minAmount) {
                this.splitAmount = this.minAmount;
            }
            if (this.splitAmount > this.maxAmount) {
                this.splitAmount = this.maxAmount;
            }
            this.lastPoint.set(x, y);
        } else {
            float dragY;
            float delta = y - this.lastPoint.y;
            float availHeight = this.height - handle.getTotalHeight();
            this.handlePosition.y = dragY = this.handlePosition.y + delta;
            dragY = Math.max(0.0f, dragY);
            dragY = Math.min(availHeight, dragY);
            this.splitAmount = 1.0f - dragY / availHeight;
            if (this.splitAmount < this.minAmount) {
                this.splitAmount = this.minAmount;
            }
            if (this.splitAmount > this.maxAmount) {
                this.splitAmount = this.maxAmount;
            }
            this.lastPoint.set(x, y);
        }
        this.invalidate();
    }

    public void setSplitAmount(float split) {
        this.splitAmount = Math.max(Math.min(this.maxAmount, split), this.minAmount);
        this.invalidate();
    }

    public float getSplit() {
        return this.splitAmount;
    }

    public void setMinSplitAmount(float minAmount) {
        if (minAmount < 0.0f) {
            throw new GdxRuntimeException("minAmount has to be >= 0");
        }
        if (minAmount >= this.maxAmount) {
            throw new GdxRuntimeException("minAmount has to be < maxAmount");
        }
        this.minAmount = minAmount;
    }

    public void setMaxSplitAmount(float maxAmount) {
        if (maxAmount > 1.0f) {
            throw new GdxRuntimeException("maxAmount has to be >= 0");
        }
        if (maxAmount <= this.minAmount) {
            throw new GdxRuntimeException("maxAmount has to be > minAmount");
        }
        this.maxAmount = maxAmount;
    }

    public void setFirstWidget(Actor widget) {
        if (this.firstWidget != null) {
            super.removeActor(this.firstWidget);
        }
        this.firstWidget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
        this.invalidate();
    }

    public void setSecondWidget(Actor widget) {
        if (this.secondWidget != null) {
            super.removeActor(this.secondWidget);
        }
        this.secondWidget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
        this.invalidate();
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorAt(int index, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorBefore(Actor actorBefore, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void removeActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget(null).");
    }

    @Override
    public void removeActorRecursive(Actor actor) {
        if (actor == this.firstWidget) {
            this.setFirstWidget(null);
        } else if (actor == this.firstWidget) {
            this.setSecondWidget(null);
        } else {
            if (this.firstWidget instanceof Group) {
                ((Group)this.firstWidget).removeActorRecursive(actor);
            }
            if (this.secondWidget instanceof Group) {
                ((Group)this.secondWidget).removeActorRecursive(actor);
            }
        }
    }

    public static class SplitPaneStyle {
        public NinePatch handle;

        public SplitPaneStyle() {
        }

        public SplitPaneStyle(NinePatch handle) {
            this.handle = handle;
        }

        public SplitPaneStyle(SplitPaneStyle style) {
            this.handle = style.handle;
        }
    }
}

