/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;

public class Slider
extends Widget {
    private SliderStyle style;
    private float min;
    private float max;
    private float steps;
    private float value;
    private float sliderPos;
    private ValueChangedListener listener = null;
    private boolean isDragging;

    public Slider(Skin skin) {
        this(0.0f, 100.0f, 100.0f, skin);
    }

    public Slider(float min, float max, float steps, Skin skin) {
        this(min, max, steps, skin.getStyle(SliderStyle.class), null);
    }

    public Slider(float min, float max, float steps, SliderStyle style) {
        this(min, max, steps, style, null);
    }

    public Slider(float min, float max, float steps, SliderStyle style, String name) {
        super(name);
        if (min > max) {
            throw new IllegalArgumentException("min must be > max: " + min + " > " + max);
        }
        if (steps < 0.0f) {
            throw new IllegalArgumentException("steps must be > 0: " + steps);
        }
        this.setStyle(style);
        this.min = min;
        this.max = max;
        this.steps = steps;
        this.value = min;
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public void setStyle(SliderStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.invalidateHierarchy();
    }

    public SliderStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        TextureRegion knob = this.style.knob;
        NinePatch slider = this.style.slider;
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        this.sliderPos = (this.value - this.min) / (this.max - this.min) * (this.width - (float)knob.getRegionWidth());
        this.sliderPos = Math.max(0.0f, this.sliderPos);
        this.sliderPos = Math.min(this.width - (float)knob.getRegionWidth(), this.sliderPos);
        slider.draw(batch, this.x, this.y + (float)((int)((this.height - slider.getTotalHeight()) * 0.5f)), this.width, slider.getTotalHeight());
        batch.draw(knob, this.x + this.sliderPos, this.y + (float)((int)((this.height - (float)knob.getRegionHeight()) * 0.5f)));
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        this.isDragging = true;
        this.calculatePositionAndValue(x);
        return true;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        this.isDragging = false;
        this.calculatePositionAndValue(x);
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        this.calculatePositionAndValue(x);
    }

    private void calculatePositionAndValue(float x) {
        TextureRegion knob = this.style.knob;
        this.sliderPos = x - (float)(knob.getRegionWidth() / 2);
        this.sliderPos = Math.max(0.0f, this.sliderPos);
        this.sliderPos = Math.min(this.width - (float)knob.getRegionWidth(), this.sliderPos);
        this.value = this.min + (this.max - this.min) * (this.sliderPos / (this.width - (float)knob.getRegionWidth()));
        if (this.listener != null) {
            this.listener.changed(this, this.getValue());
        }
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setValueChangedListener(ValueChangedListener listener) {
        this.listener = listener;
    }

    public float getValue() {
        return (float)Math.floor(this.value / this.steps) * this.steps;
    }

    public void setValue(float value) {
        if (value < this.min || value > this.max) {
            throw new IllegalArgumentException("value must be >= min and <= max: " + value);
        }
        this.value = value;
    }

    public void setRange(float min, float max) {
        if (min >= max) {
            throw new IllegalArgumentException("min must be < max");
        }
        this.min = min;
        this.max = max;
        this.value = min;
        if (this.listener != null) {
            this.listener.changed(this, this.getValue());
        }
    }

    @Override
    public float getPrefWidth() {
        return 140.0f;
    }

    @Override
    public float getPrefHeight() {
        return Math.max((float)this.style.knob.getRegionHeight(), this.style.slider.getTotalHeight());
    }

    public static class SliderStyle {
        NinePatch slider;
        TextureRegion knob;

        public SliderStyle() {
        }

        public SliderStyle(NinePatch sliderPatch, TextureRegion knobRegion) {
            this.slider = sliderPatch;
            this.knob = knobRegion;
        }

        public SliderStyle(SliderStyle style) {
            this.slider = style.slider;
            this.knob = style.knob;
        }
    }

    public static interface ValueChangedListener {
        public void changed(Slider var1, float var2);
    }
}

