/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.ClickListener;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.utils.Scaling;

public class Image
extends Widget {
    private TextureRegion region;
    private NinePatch patch;
    private Scaling scaling;
    private int align = 1;
    private float imageX;
    private float imageY;
    private float imageWidth;
    private float imageHeight;
    private ClickListener clickListener;

    public Image() {
        this((TextureRegion)null);
    }

    public Image(Texture texture) {
        this(new TextureRegion(texture));
    }

    public Image(Texture texture, Scaling scaling) {
        this(new TextureRegion(texture), scaling);
    }

    public Image(Texture texture, Scaling scaling, int align) {
        this(new TextureRegion(texture), scaling, align);
    }

    public Image(Texture texture, Scaling scaling, int align, String name) {
        this(new TextureRegion(texture), scaling, align, name);
    }

    public Image(TextureRegion region) {
        this(region, Scaling.stretch, 1, null);
    }

    public Image(TextureRegion region, Scaling scaling) {
        this(region, scaling, 1, null);
    }

    public Image(TextureRegion region, Scaling scaling, int align) {
        this(region, scaling, align, null);
    }

    public Image(TextureRegion region, Scaling scaling, int align, String name) {
        super(name);
        this.setRegion(region);
        this.scaling = scaling;
        this.align = align;
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public Image(NinePatch patch) {
        this(patch, Scaling.stretch, 1, null);
    }

    public Image(NinePatch patch, Scaling scaling) {
        this(patch, scaling, 1, null);
    }

    public Image(NinePatch patch, Scaling scaling, int align) {
        this(patch, scaling, align, null);
    }

    public Image(NinePatch patch, Scaling scaling, int align, String name) {
        super(name);
        this.setPatch(patch);
        this.scaling = scaling;
        this.align = align;
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    @Override
    public void layout() {
        float regionHeight;
        float regionWidth;
        if (this.patch != null) {
            regionWidth = this.patch.getTotalWidth();
            regionHeight = this.patch.getTotalHeight();
        } else if (this.region != null) {
            regionWidth = this.region.getRegionWidth();
            regionHeight = this.region.getRegionHeight();
        } else {
            return;
        }
        Vector2 size = this.scaling.apply(regionWidth, regionHeight, this.width, this.height);
        this.imageWidth = size.x;
        this.imageHeight = size.y;
        this.imageX = (this.align & 8) != 0 ? 0.0f : ((this.align & 0x10) != 0 ? (float)((int)(this.width - this.imageWidth)) : (float)((int)(this.width / 2.0f - this.imageWidth / 2.0f)));
        this.imageY = (this.align & 2) != 0 ? (float)((int)(this.height - this.imageHeight)) : ((this.align & 4) != 0 ? 0.0f : (float)((int)(this.height / 2.0f - this.imageHeight / 2.0f)));
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        this.validate();
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        if (this.patch != null) {
            this.patch.draw(batch, this.x + this.imageX, this.y + this.imageY, this.imageWidth * this.scaleX, this.imageHeight * this.scaleY);
        } else if (this.region != null) {
            if (this.scaleX == 1.0f && this.scaleY == 1.0f && this.rotation == 0.0f) {
                batch.draw(this.region, this.x + this.imageX, this.y + this.imageY, this.imageWidth, this.imageHeight);
            } else {
                batch.draw(this.region, this.x + this.imageX, this.y + this.imageY, this.originX - this.imageX, this.originY - this.imageY, this.imageWidth, this.imageHeight, this.scaleX, this.scaleY, this.rotation);
            }
        }
    }

    public void setRegion(TextureRegion region) {
        if (region != null) {
            if (this.region == region) {
                return;
            }
            if (this.getPrefWidth() != (float)region.getRegionWidth() || this.getPrefHeight() != (float)region.getRegionHeight()) {
                this.invalidateHierarchy();
            }
        } else if (this.getPrefWidth() != 0.0f || this.getPrefHeight() != 0.0f) {
            this.invalidateHierarchy();
        }
        this.region = region;
        this.patch = null;
    }

    public TextureRegion getRegion() {
        return this.region;
    }

    public void setPatch(NinePatch patch) {
        if (patch != null) {
            if (this.patch == patch) {
                return;
            }
            if (this.getPrefWidth() != patch.getTotalWidth() || this.getPrefHeight() != patch.getTotalHeight()) {
                this.invalidateHierarchy();
            }
        } else if (this.getPrefWidth() != 0.0f || this.getPrefHeight() != 0.0f) {
            this.invalidateHierarchy();
        }
        this.patch = patch;
        this.region = null;
    }

    public NinePatch getPatch() {
        return this.patch;
    }

    public void setScaling(Scaling scaling) {
        if (scaling == null) {
            throw new IllegalArgumentException("scaling cannot be null.");
        }
        this.scaling = scaling;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getPrefWidth() {
        if (this.region != null) {
            return this.region.getRegionWidth();
        }
        if (this.patch != null) {
            return this.patch.getTotalWidth();
        }
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.region != null) {
            return this.region.getRegionHeight();
        }
        if (this.patch != null) {
            return this.patch.getTotalHeight();
        }
        return 0.0f;
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        return this.clickListener != null;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        if (this.hit(x, y) == null) {
            return;
        }
        if (this.clickListener != null) {
            this.clickListener.click(this, x, y);
        }
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
    }

    public void setClickListener(ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public float getImageX() {
        return this.imageX;
    }

    public float getImageY() {
        return this.imageY;
    }

    public float getImageWidth() {
        return this.imageWidth;
    }

    public float getImageHeight() {
        return this.imageHeight;
    }
}

