/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.AnimationAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class RotateTo
extends AnimationAction {
    private static final ActionResetingPool<RotateTo> pool = new ActionResetingPool<RotateTo>(4, 100){

        @Override
        protected RotateTo newObject() {
            return new RotateTo();
        }
    };
    protected float rotation;
    protected float startRotation;
    protected float deltaRotation;

    public static RotateTo $(float rotation, float duration) {
        RotateTo action = (RotateTo)pool.obtain();
        action.rotation = rotation;
        action.duration = duration;
        action.invDuration = 1.0f / duration;
        return action;
    }

    @Override
    public void setTarget(Actor actor) {
        this.target = actor;
        this.startRotation = this.target.rotation;
        this.deltaRotation = this.rotation - this.target.rotation;
        this.taken = 0.0f;
        this.done = false;
    }

    @Override
    public void act(float delta) {
        float alpha = this.createInterpolatedAlpha(delta);
        this.target.rotation = this.done ? this.rotation : this.startRotation + this.deltaRotation * alpha;
    }

    @Override
    public void finish() {
        super.finish();
        pool.free(this);
    }

    @Override
    public Action copy() {
        RotateTo rotateTo = RotateTo.$(this.rotation, this.duration);
        if (this.interpolator != null) {
            rotateTo.setInterpolator(this.interpolator.copy());
        }
        return rotateTo;
    }
}

