/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.utils.GdxNativesLoader;
import java.lang.reflect.Method;

final class LwjglNativesLoader {
    public static boolean load = true;

    LwjglNativesLoader() {
    }

    static void load() {
        GdxNativesLoader.load();
        if (GdxNativesLoader.disableNativesLoading) {
            return;
        }
        if (!load) {
            return;
        }
        if (GdxNativesLoader.isWindows) {
            GdxNativesLoader.extractLibrary("OpenAL32.dll", "OpenAL64.dll");
            GdxNativesLoader.extractLibrary("lwjgl.dll", "lwjgl64.dll");
        } else if (GdxNativesLoader.isMac) {
            GdxNativesLoader.extractLibrary("openal.dylib", "openal.dylib");
            GdxNativesLoader.extractLibrary("liblwjgl.jnilib", "liblwjgl.jnilib");
        } else if (GdxNativesLoader.isLinux) {
            GdxNativesLoader.extractLibrary("libopenal.so", "libopenal64.so");
            GdxNativesLoader.extractLibrary("liblwjgl.so", "liblwjgl64.so");
        }
        System.setProperty("org.lwjgl.librarypath", GdxNativesLoader.nativesDir.getAbsolutePath());
        load = false;
    }

    static {
        System.setProperty("org.lwjgl.input.Mouse.allowNegativeMouseCoords", "true");
        try {
            Method method = Class.forName("javax.jnlp.ServiceManager").getDeclaredMethod("lookup", String.class);
            method.invoke(null, "javax.jnlp.PersistenceService");
            load = false;
        }
        catch (Throwable ex) {
            load = true;
        }
    }
}

