/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.backends.lwjgl.LwjglGraphics;
import com.badlogic.gdx.graphics.GL10;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

class LwjglGL10
implements GL10 {
    private IntBuffer tempInt;
    private FloatBuffer tempFloat;
    IntBuffer getBuffer = BufferUtils.createIntBuffer(100);

    public LwjglGL10() {
        this.tempInt = BufferUtils.createIntBuffer(8);
        this.tempFloat = BufferUtils.createFloatBuffer(8);
    }

    private IntBuffer toBuffer(int n, int[] src, int offset) {
        if (this.tempInt.capacity() < n) {
            this.tempInt = BufferUtils.createIntBuffer(n);
        } else {
            this.tempInt.clear();
        }
        this.tempInt.put(src, offset, n);
        this.tempInt.flip();
        return this.tempInt;
    }

    private IntBuffer toBuffer(int[] src, int offset) {
        int n = src.length - offset;
        if (this.tempInt.capacity() < n) {
            this.tempInt = BufferUtils.createIntBuffer(n);
        } else {
            this.tempInt.clear();
        }
        this.tempInt.put(src, offset, n);
        this.tempInt.flip();
        return this.tempInt;
    }

    private FloatBuffer toBuffer(float[] src, int offset) {
        int n = src.length - offset;
        if (this.tempFloat.capacity() < n) {
            this.tempFloat = BufferUtils.createFloatBuffer(n);
        } else {
            this.tempFloat.clear();
        }
        this.tempFloat.put(src, offset, src.length - offset);
        this.tempFloat.flip();
        return this.tempFloat;
    }

    @Override
    public final void glActiveTexture(int texture) {
        GL13.glActiveTexture(texture);
    }

    @Override
    public final void glAlphaFunc(int func, float ref) {
        GL11.glAlphaFunc(func, ref);
    }

    @Override
    public final void glBindTexture(int target, int texture) {
        GL11.glBindTexture(target, texture);
    }

    @Override
    public final void glBlendFunc(int sfactor, int dfactor) {
        GL11.glBlendFunc(sfactor, dfactor);
    }

    @Override
    public final void glClear(int mask) {
        GL11.glClear(mask);
    }

    @Override
    public final void glClearColor(float red, float green, float blue, float alpha) {
        GL11.glClearColor(red, green, blue, alpha);
    }

    @Override
    public final void glClearDepthf(float depth) {
        GL11.glClearDepth(depth);
    }

    @Override
    public final void glClearStencil(int s) {
        GL11.glClearStencil(s);
    }

    @Override
    public final void glClientActiveTexture(int texture) {
        try {
            GL13.glClientActiveTexture(texture);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public final void glColor4f(float red, float green, float blue, float alpha) {
        GL11.glColor4f(red, green, blue, alpha);
    }

    @Override
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GL11.glColorMask(red, green, blue, alpha);
    }

    @Override
    public final void glColorPointer(int size, int type, int stride, Buffer pointer) {
        if (pointer instanceof FloatBuffer && type == 5126) {
            GL11.glColorPointer(size, stride, (FloatBuffer)pointer);
        } else if (pointer instanceof ByteBuffer && type == 5126) {
            GL11.glColorPointer(size, stride, ((ByteBuffer)pointer).asFloatBuffer());
        } else if (pointer instanceof ByteBuffer && type == 5121) {
            GL11.glColorPointer(size, true, stride, (ByteBuffer)pointer);
        } else {
            throw new GdxRuntimeException("Can't use " + pointer.getClass().getName() + " with this method, use FloatBuffer or ByteBuffer. blame LWJGL");
        }
    }

    @Override
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        if (!(data instanceof ByteBuffer)) {
            throw new GdxRuntimeException("Can't use " + data.getClass().getName() + " with this method. Use ByteBuffer. Blame LWJGL");
        }
        GL13.glCompressedTexImage2D(target, level, internalformat, width, height, border, (ByteBuffer)data);
    }

    @Override
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        if (!(data instanceof ByteBuffer)) {
            throw new GdxRuntimeException("Can't use " + data.getClass().getName() + " with this method. Use ByteBuffer. Blame LWJGL");
        }
        GL13.glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, (ByteBuffer)data);
    }

    @Override
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        GL11.glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
    }

    @Override
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GL11.glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    }

    @Override
    public final void glCullFace(int mode) {
        GL11.glCullFace(mode);
    }

    @Override
    public final void glDeleteTextures(int n, IntBuffer textures) {
        GL11.glDeleteTextures(textures);
    }

    @Override
    public final void glDepthFunc(int func) {
        GL11.glDepthFunc(func);
    }

    @Override
    public final void glDepthMask(boolean flag) {
        GL11.glDepthMask(flag);
    }

    @Override
    public final void glDepthRangef(float zNear, float zFar) {
        GL11.glDepthRange(zNear, zFar);
    }

    @Override
    public final void glDisable(int cap) {
        GL11.glDisable(cap);
    }

    @Override
    public final void glDisableClientState(int array) {
        GL11.glDisableClientState(array);
    }

    @Override
    public final void glDrawArrays(int mode, int first, int count) {
        GL11.glDrawArrays(mode, first, count);
    }

    @Override
    public final void glDrawElements(int mode, int count, int type, Buffer indices) {
        if (indices instanceof ShortBuffer && type == 5123) {
            GL11.glDrawElements(mode, (ShortBuffer)indices);
        } else if (indices instanceof ByteBuffer && type == 5123) {
            GL11.glDrawElements(mode, ((ByteBuffer)indices).asShortBuffer());
        } else if (indices instanceof ByteBuffer && type == 5121) {
            GL11.glDrawElements(mode, (ByteBuffer)indices);
        } else {
            throw new GdxRuntimeException("Can't use " + indices.getClass().getName() + " with this method. Use ShortBuffer or ByteBuffer instead. Blame LWJGL");
        }
    }

    @Override
    public final void glEnable(int cap) {
        GL11.glEnable(cap);
    }

    @Override
    public final void glEnableClientState(int array) {
        GL11.glEnableClientState(array);
    }

    @Override
    public final void glFinish() {
        GL11.glFinish();
    }

    @Override
    public final void glFlush() {
        GL11.glFlush();
    }

    @Override
    public final void glFogf(int pname, float param) {
        GL11.glFogf(pname, param);
    }

    @Override
    public final void glFogfv(int pname, FloatBuffer params) {
        GL11.glFog(pname, params);
    }

    @Override
    public final void glFrontFace(int mode) {
        GL11.glFrontFace(mode);
    }

    @Override
    public final void glFrustumf(float left, float right, float bottom, float top, float zNear, float zFar) {
        GL11.glFrustum(left, right, bottom, top, zNear, zFar);
    }

    @Override
    public final void glGenTextures(int n, IntBuffer textures) {
        GL11.glGenTextures(textures);
    }

    @Override
    public final int glGetError() {
        return GL11.glGetError();
    }

    @Override
    public final void glGetIntegerv(int pname, IntBuffer params) {
        GL11.glGetInteger(pname, params);
    }

    @Override
    public final String glGetString(int name) {
        return GL11.glGetString(name);
    }

    @Override
    public final void glHint(int target, int mode) {
        GL11.glHint(target, mode);
    }

    @Override
    public final void glLightModelf(int pname, float param) {
        GL11.glLightModelf(pname, param);
    }

    @Override
    public final void glLightModelfv(int pname, FloatBuffer params) {
        GL11.glLightModel(pname, params);
    }

    @Override
    public final void glLightf(int light, int pname, float param) {
        GL11.glLightf(light, pname, param);
    }

    @Override
    public final void glLightfv(int light, int pname, FloatBuffer params) {
        GL11.glLight(light, pname, params);
    }

    @Override
    public final void glLineWidth(float width) {
        GL11.glLineWidth(width);
    }

    @Override
    public final void glLoadIdentity() {
        GL11.glLoadIdentity();
    }

    @Override
    public final void glLoadMatrixf(FloatBuffer m) {
        GL11.glLoadMatrix(m);
    }

    @Override
    public final void glLogicOp(int opcode) {
        GL11.glLogicOp(opcode);
    }

    @Override
    public final void glMaterialf(int face, int pname, float param) {
        GL11.glMaterialf(face, pname, param);
    }

    @Override
    public final void glMaterialfv(int face, int pname, FloatBuffer params) {
        GL11.glMaterial(face, pname, params);
    }

    @Override
    public final void glMatrixMode(int mode) {
        GL11.glMatrixMode(mode);
    }

    @Override
    public final void glMultMatrixf(FloatBuffer m) {
        GL11.glMultMatrix(m);
    }

    @Override
    public final void glMultiTexCoord4f(int target, float s, float t, float r, float q) {
        GL13.glMultiTexCoord4f(target, s, t, r, q);
    }

    @Override
    public final void glNormal3f(float nx, float ny, float nz) {
        GL11.glNormal3f(nx, ny, nz);
    }

    @Override
    public final void glNormalPointer(int type, int stride, Buffer pointer) {
        if (pointer instanceof FloatBuffer && type == 5126) {
            GL11.glNormalPointer(stride, (FloatBuffer)pointer);
        } else if (pointer instanceof ByteBuffer && type == 5126) {
            GL11.glNormalPointer(stride, ((ByteBuffer)pointer).asFloatBuffer());
        } else if (pointer instanceof ByteBuffer && type == 5120) {
            GL11.glNormalPointer(stride, (ByteBuffer)pointer);
        } else {
            throw new GdxRuntimeException("Can't use " + pointer.getClass().getName() + " with this method. GL10.GL_SHORT not supported. Use FloatBuffer instead. Blame LWJGL");
        }
    }

    @Override
    public final void glOrthof(float left, float right, float bottom, float top, float zNear, float zFar) {
        GL11.glOrtho(left, right, bottom, top, zNear, zFar);
    }

    @Override
    public final void glPixelStorei(int pname, int param) {
        GL11.glPixelStorei(pname, param);
    }

    @Override
    public final void glPointSize(float size) {
        GL11.glPointSize(size);
    }

    @Override
    public final void glPolygonOffset(float factor, float units) {
        GL11.glPolygonOffset(factor, units);
    }

    @Override
    public final void glPopMatrix() {
        GL11.glPopMatrix();
    }

    @Override
    public final void glPushMatrix() {
        GL11.glPushMatrix();
    }

    @Override
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        if (pixels instanceof ByteBuffer) {
            GL11.glReadPixels(x, y, width, height, format, type, (ByteBuffer)pixels);
        } else if (pixels instanceof ShortBuffer) {
            GL11.glReadPixels(x, y, width, height, format, type, (ShortBuffer)pixels);
        } else if (pixels instanceof IntBuffer) {
            GL11.glReadPixels(x, y, width, height, format, type, (IntBuffer)pixels);
        } else if (pixels instanceof FloatBuffer) {
            GL11.glReadPixels(x, y, width, height, format, type, (FloatBuffer)pixels);
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer or FloatBuffer instead. Blame LWJGL");
        }
    }

    @Override
    public final void glRotatef(float angle, float x, float y, float z) {
        GL11.glRotatef(angle, x, y, z);
    }

    @Override
    public final void glSampleCoverage(float value, boolean invert) {
        GL13.glSampleCoverage(value, invert);
    }

    @Override
    public final void glScalef(float x, float y, float z) {
        GL11.glScalef(x, y, z);
    }

    @Override
    public final void glScissor(int x, int y, int width, int height) {
        GL11.glScissor(x, y, width, height);
    }

    @Override
    public final void glShadeModel(int mode) {
        GL11.glShadeModel(mode);
    }

    @Override
    public final void glStencilFunc(int func, int ref, int mask) {
        GL11.glStencilFunc(func, ref, mask);
    }

    @Override
    public final void glStencilMask(int mask) {
        GL11.glStencilMask(mask);
    }

    @Override
    public final void glStencilOp(int fail, int zfail, int zpass) {
        GL11.glStencilOp(fail, zfail, zpass);
    }

    @Override
    public final void glTexCoordPointer(int size, int type, int stride, Buffer pointer) {
        if (pointer instanceof ShortBuffer && type == 5122) {
            GL11.glTexCoordPointer(size, stride, (ShortBuffer)pointer);
        } else if (pointer instanceof ByteBuffer && type == 5122) {
            GL11.glTexCoordPointer(size, stride, ((ByteBuffer)pointer).asShortBuffer());
        } else if (pointer instanceof FloatBuffer && type == 5126) {
            GL11.glTexCoordPointer(size, stride, (FloatBuffer)pointer);
        } else if (pointer instanceof ByteBuffer && type == 5126) {
            GL11.glTexCoordPointer(size, stride, ((ByteBuffer)pointer).asFloatBuffer());
        } else {
            throw new GdxRuntimeException("Can't use " + pointer.getClass().getName() + " with this method. Use ShortBuffer or FloatBuffer or ByteBuffer instead with GL_FLOAT or GL_SHORT. GL_BYTE is not supported. Blame LWJGL");
        }
    }

    @Override
    public final void glTexEnvf(int target, int pname, float param) {
        GL11.glTexEnvf(target, pname, param);
    }

    @Override
    public final void glTexEnvfv(int target, int pname, FloatBuffer params) {
        GL11.glTexEnv(target, pname, params);
    }

    @Override
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        if (pixels == null) {
            GL11.glTexImage2D(target, level, internalformat, width, height, border, format, type, (ByteBuffer)null);
        } else if (pixels instanceof ByteBuffer) {
            GL11.glTexImage2D(target, level, internalformat, width, height, border, format, type, (ByteBuffer)pixels);
        } else if (pixels instanceof ShortBuffer) {
            GL11.glTexImage2D(target, level, internalformat, width, height, border, format, type, (ShortBuffer)pixels);
        } else if (pixels instanceof IntBuffer) {
            GL11.glTexImage2D(target, level, internalformat, width, height, border, format, type, (IntBuffer)pixels);
        } else if (pixels instanceof FloatBuffer) {
            GL11.glTexImage2D(target, level, internalformat, width, height, border, format, type, (FloatBuffer)pixels);
        } else if (pixels instanceof DoubleBuffer) {
            GL11.glTexImage2D(target, level, internalformat, width, height, border, format, type, (DoubleBuffer)pixels);
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer, FloatBuffer or DoubleBuffer instead. Blame LWJGL");
        }
    }

    @Override
    public final void glTexParameterf(int target, int pname, float param) {
        if (LwjglGraphics.minor < 2 && param == 33071.0f) {
            param = 10496.0f;
        }
        GL11.glTexParameterf(target, pname, param);
    }

    @Override
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        if (pixels instanceof ByteBuffer) {
            GL11.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, (ByteBuffer)pixels);
        } else if (pixels instanceof ShortBuffer) {
            GL11.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, (ShortBuffer)pixels);
        } else if (pixels instanceof IntBuffer) {
            GL11.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, (IntBuffer)pixels);
        } else if (pixels instanceof FloatBuffer) {
            GL11.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, (FloatBuffer)pixels);
        } else if (pixels instanceof DoubleBuffer) {
            GL11.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, (DoubleBuffer)pixels);
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer, FloatBuffer or DoubleBuffer instead. Blame LWJGL");
        }
    }

    @Override
    public final void glTranslatef(float x, float y, float z) {
        GL11.glTranslatef(x, y, z);
    }

    @Override
    public final void glVertexPointer(int size, int type, int stride, Buffer pointer) {
        if (pointer instanceof FloatBuffer && type == 5126) {
            GL11.glVertexPointer(size, stride, (FloatBuffer)pointer);
        } else if (pointer instanceof ByteBuffer && type == 5126) {
            GL11.glVertexPointer(size, stride, ((ByteBuffer)pointer).asFloatBuffer());
        } else {
            throw new GdxRuntimeException("Can't use " + pointer.getClass().getName() + " with this method. Use FloatBuffer or ByteBuffers with GL10.GL_FLOAT instead. Blame LWJGL");
        }
    }

    @Override
    public final void glViewport(int x, int y, int width, int height) {
        GL11.glViewport(x, y, width, height);
    }

    @Override
    public final void glDeleteTextures(int n, int[] textures, int offset) {
        GL11.glDeleteTextures(this.toBuffer(n, textures, offset));
    }

    @Override
    public final void glFogfv(int pname, float[] params, int offset) {
        GL11.glFog(pname, this.toBuffer(params, offset));
    }

    @Override
    public final void glGenTextures(int n, int[] textures, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            textures[i] = GL11.glGenTextures();
        }
    }

    @Override
    public final void glGetIntegerv(int pname, int[] params, int offset) {
        GL11.glGetInteger(pname, this.getBuffer);
        int i = offset;
        int j = 0;
        while (i < params.length) {
            if (j == this.getBuffer.capacity()) {
                return;
            }
            params[i] = this.getBuffer.get(j);
            ++i;
            ++j;
        }
    }

    @Override
    public final void glLightModelfv(int pname, float[] params, int offset) {
        GL11.glLightModel(pname, this.toBuffer(params, offset));
    }

    @Override
    public final void glLightfv(int light, int pname, float[] params, int offset) {
        GL11.glLight(light, pname, this.toBuffer(params, offset));
    }

    @Override
    public final void glLoadMatrixf(float[] m, int offset) {
        GL11.glLoadMatrix(this.toBuffer(m, offset));
    }

    @Override
    public final void glMaterialfv(int face, int pname, float[] params, int offset) {
        GL11.glMaterial(face, pname, this.toBuffer(params, offset));
    }

    @Override
    public final void glMultMatrixf(float[] m, int offset) {
        GL11.glMultMatrix(this.toBuffer(m, offset));
    }

    @Override
    public final void glTexEnvfv(int target, int pname, float[] params, int offset) {
        GL11.glTexEnv(target, pname, this.toBuffer(params, offset));
    }

    @Override
    public void glPolygonMode(int face, int mode) {
        GL11.glPolygonMode(face, mode);
    }
}

