/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;

public class World_Menu_Main
extends World_Menu {
    private Texture menuTexture;
    public MenuItem itemContinue;
    private MenuItem itemSound;
    private MenuItem itemMusic;

    public World_Menu_Main(App a) {
        super(a);
    }

    @Override
    public void create() {
        super.create();
        int level = this.app.config.getInt("level", 0);
        boolean firstLevel = level == 0 || level == this.app_mm.game.getLevelCount() || this.app_mm.game.user.live <= 0;
        this.itemContinue = new MenuItem("Continue game", 2, firstLevel);
        String on = this.app.config.getInt("sound", 0) == 0 ? "off" : "on";
        this.itemSound = new MenuItem("Sound: " + on, 3);
        on = this.app.config.getInt("music", 0) == 0 ? "off" : "on";
        this.itemMusic = new MenuItem("Music: " + on, 4);
        this.items.add(new MenuItem("Start new game", 1));
        this.items.add(this.itemContinue);
        this.items.add(this.itemSound);
        this.items.add(this.itemMusic);
        this.items.add(new MenuItem("Help", 5));
        this.items.add(new MenuItem("Credits", 6));
        this.items.add(new MenuItem("Quit game", 7));
        this.activeId = firstLevel ? 1 : 2;
        this.menuTexture = new Texture(Gdx.files.internal("data/textures/menu.png"));
    }

    @Override
    public void render() {
        this.app_mm.game.render();
        this.spriteBatch.begin();
        World_Menu_Main.camera.zoom = 0.5f;
        World_Menu_Main.camera.position.x = 200.0f;
        World_Menu_Main.camera.position.y = 150.0f;
        this.useCamera();
        this.spriteBatch.draw(this.menuTexture, 100.0f, 50.0f, 200.0f, 145.0f);
        this.spriteBatch.draw(this.titleTexture, 50.0f, -20.0f, 400.0f, 300.0f);
        this.renderMenu(150.0f, 184.0f);
        this.spriteBatch.end();
    }

    @Override
    public void onEnter() {
        if (this.activeId == 1) {
            if (!this.itemContinue.disabled) {
                this.app_mm.confirm.msg = "START NEW GAME";
                this.app_mm.confirm.okText = "Restart game";
                this.app_mm.confirm.cancelText = "Back to menu";
                this.app_mm.confirm.prevWorld = this;
                this.app_mm.confirm.init();
                this.app_mm.setWorld(this.app_mm.confirm);
                return;
            }
            this.itemContinue.disabled = false;
            this.activeId = 2;
            this.app_mm.game.reset();
            this.app_mm.game.load();
            this.app_mm.setWorld(this.app_mm.game);
        } else if (this.activeId == 2) {
            if (this.app_mm.game.user.isDied()) {
                this.app_mm.game.load();
            }
            this.app_mm.setWorld(this.app_mm.game);
        } else if (this.activeId == 3) {
            if (this.itemSound.name.equals("Sound: on")) {
                this.itemSound.name = "Sound: off";
                this.app.config.setInt("sound", 0);
            } else {
                this.itemSound.name = "Sound: on";
                this.app.config.setInt("sound", 1);
            }
        } else if (this.activeId == 4) {
            if (this.itemMusic.name.equals("Music: on")) {
                this.itemMusic.name = "Music: off";
                this.app.setMusicVolume(0.0f);
                this.app.config.setInt("music", 0);
            } else {
                this.itemMusic.name = "Music: on";
                this.app.setMusicVolume(0.4f);
                this.app.config.setInt("music", 1);
            }
        } else if (this.activeId == 5) {
            this.app_mm.setWorld(this.app_mm.help);
        } else if (this.activeId == 6) {
            this.app_mm.setWorld(this.app_mm.credits);
        } else if (this.activeId == 7) {
            this.app_mm.confirm.msg = "QUIT GAME";
            this.app_mm.confirm.okText = "Exit to system";
            this.app_mm.confirm.cancelText = "Back to menu";
            this.app_mm.confirm.prevWorld = this;
            this.app_mm.confirm.init();
            this.app_mm.setWorld(this.app_mm.confirm);
        }
    }

    @Override
    public void confirmOk() {
        if (this.activeId == 1) {
            this.itemContinue.disabled = true;
            this.onEnter();
        }
        if (this.activeId == 7) {
            Gdx.app.exit();
        }
    }
}

