/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.math.Vector2;

public class Grid {
    int[][] data;
    int maxWidth;
    int maxHeight;
    int width;
    int height;
    Vector2 rayDir = new Vector2();
    Vector2 ray = new Vector2();

    public Grid(int mx, int mh) {
        this.maxWidth = mx;
        this.maxHeight = mh;
        this.data = new int[this.maxWidth][this.maxHeight];
    }

    public void set(int x, int y, int v) {
        if (x >= this.maxWidth || x < 0 || y >= this.maxHeight || y < 0) {
            return;
        }
        if (x >= this.width) {
            this.width = x + 1;
        }
        if (y >= this.height) {
            this.height = x + 1;
        }
        int[] nArray = this.data[x];
        int n = y;
        nArray[n] = nArray[n] | v;
    }

    public void unset(int x, int y, int v) {
        if (x >= this.width || x < 0 || y >= this.height || y < 0) {
            return;
        }
        this.data[x][y] = v;
    }

    public int get(int x, int y) {
        if (x >= this.maxWidth || x < 0) {
            return 1;
        }
        if (y >= this.maxHeight || y < 0) {
            return 0;
        }
        return this.data[x][y];
    }

    public boolean is(int x, int y, int v) {
        return (this.get(x, y) & v) == v;
    }

    public void clear() {
        int j = 0;
        while (j < this.maxHeight) {
            int i = 0;
            while (i < this.maxWidth) {
                this.data[i][j] = 0;
                ++i;
            }
            ++j;
        }
    }

    public boolean intersectSegment(Vector2 from, Vector2 to, int v, Vector2 intSec) {
        float xd;
        float yd;
        intSec.set(0.0f, 0.0f);
        this.rayDir.set(to);
        this.rayDir.sub(from);
        float sx = Math.signum(this.rayDir.x);
        float sy = Math.signum(this.rayDir.y);
        float rsy = 0.0f;
        float rsx = 0.0f;
        float a = 360.0f - this.rayDir.angle();
        float r = (float)Math.toRadians(a);
        float tanr = (float)Math.tan(r);
        int fmx = (int)(from.x + 0.5f);
        int fmy = (int)(from.y + 0.5f);
        int tmx = (int)(to.x + 0.5f);
        int tmy = (int)(to.y + 0.5f);
        if (tmy != fmy) {
            if (a < 360.0f && a > 180.0f) {
                this.ray.y = fmy + 1;
                yd = 1.0f;
            } else {
                this.ray.y = (float)fmy - 1.0E-4f;
                yd = -1.0f;
            }
            this.ray.x = from.x + 0.5f + (from.y + 0.5f - this.ray.y) / tanr;
            xd = -yd / tanr;
            do {
                if (this.is((int)this.ray.x, (int)this.ray.y, v)) {
                    intSec.set(this.ray.x - 0.5f, this.ray.y - 0.5f);
                    return true;
                }
                this.ray.x += xd;
                this.ray.y += yd;
            } while ((rsy = Math.signum(to.y + 0.5f - this.ray.y)) == sy);
        }
        if (tmx != fmx) {
            if (a > 90.0f && a < 270.0f) {
                this.ray.x = (float)fmx - 1.0E-4f;
                xd = -1.0f;
            } else {
                this.ray.x = fmx + 1;
                xd = 1.0f;
            }
            this.ray.y = from.y + 0.5f + (from.x + 0.5f - this.ray.x) * tanr;
            yd = -xd * tanr;
            do {
                if (this.is((int)this.ray.x, (int)this.ray.y, v)) {
                    intSec.set(this.ray.x - 0.5f, this.ray.y - 0.5f);
                    return true;
                }
                this.ray.x += xd;
                this.ray.y += yd;
            } while ((rsx = Math.signum(to.x + 0.5f - this.ray.x)) == sx);
        }
        return false;
    }
}

