/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.esotericsoftware.tablelayout.Cell;

public class TextButton
extends Button {
    private final Label label;
    private TextButtonStyle style;

    public TextButton(Skin skin) {
        this("", skin);
    }

    public TextButton(String text, Skin skin) {
        this(text, skin.getStyle("default", TextButtonStyle.class));
    }

    public TextButton(String text, TextButtonStyle style) {
        this(text, style, null);
    }

    public TextButton(String text, TextButtonStyle style, String name) {
        super(style, name);
        this.style = style;
        this.label = new Label((CharSequence)text, new Label.LabelStyle(style.font, style.fontColor));
        this.label.setAlignment(1);
        this.add(this.label).expand().fill();
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof TextButtonStyle)) {
            throw new IllegalArgumentException("style must be a TextButtonStyle.");
        }
        super.setStyle(style);
        this.style = (TextButtonStyle)style;
        if (this.label != null) {
            TextButtonStyle textButtonStyle = (TextButtonStyle)style;
            Label.LabelStyle labelStyle = this.label.getStyle();
            labelStyle.font = textButtonStyle.font;
            labelStyle.fontColor = textButtonStyle.fontColor;
            this.label.setStyle(labelStyle);
        }
    }

    @Override
    public TextButtonStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        if (this.isPressed) {
            if (this.style.downFontColor != null) {
                this.label.setColor(this.style.downFontColor);
            }
        } else if (this.style.fontColor != null) {
            this.label.setColor(this.isChecked && this.style.checkedFontColor != null ? this.style.checkedFontColor : this.style.fontColor);
        }
        super.draw(batch, parentAlpha);
    }

    public Label getLabel() {
        return this.label;
    }

    public Cell getLabelCell() {
        return this.getCell(this.label);
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public CharSequence getText() {
        return this.label.getText();
    }

    public static class TextButtonStyle
    extends Button.ButtonStyle {
        public BitmapFont font;
        public Color fontColor;
        public Color downFontColor;
        public Color checkedFontColor;

        public TextButtonStyle() {
        }

        public TextButtonStyle(NinePatch down, NinePatch up, NinePatch checked, float pressedOffsetX, float pressedOffsetY, float unpressedOffsetX, float unpressedOffsetY, BitmapFont font, Color fontColor, Color downFontColor, Color checkedFontColor) {
            super(up, down, checked, pressedOffsetX, pressedOffsetY, unpressedOffsetX, unpressedOffsetY);
            this.font = font;
            this.fontColor = fontColor;
            this.downFontColor = downFontColor;
            this.checkedFontColor = checkedFontColor;
        }

        public TextButtonStyle(TextButtonStyle style) {
            super(style);
            this.font = style.font;
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            if (style.downFontColor != null) {
                this.downFontColor = new Color(style.downFontColor);
            }
            if (style.checkedFontColor != null) {
                this.checkedFontColor = new Color(style.checkedFontColor);
            }
        }
    }
}

