/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;

public class CheckBox
extends TextButton {
    private Image image;
    private CheckBoxStyle style;

    public CheckBox(Skin skin) {
        this("", skin);
    }

    public CheckBox(String text, CheckBoxStyle style) {
        this(text, style, null);
    }

    public CheckBox(String text, Skin skin) {
        this(text, skin.getStyle(CheckBoxStyle.class), null);
    }

    public CheckBox(String text, CheckBoxStyle style, String name) {
        super(text, style, name);
        this.clear();
        this.image = new Image(style.checkboxOff);
        this.add(this.image);
        Label label = this.getLabel();
        this.add(label);
        label.setAlignment(8);
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        super.setStyle(style);
        this.style = (CheckBoxStyle)style;
    }

    @Override
    public CheckBoxStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        this.image.setRegion(this.isChecked ? this.style.checkboxOn : this.style.checkboxOff);
        super.draw(batch, parentAlpha);
    }

    public Image getImage() {
        return this.image;
    }

    public static class CheckBoxStyle
    extends TextButton.TextButtonStyle {
        public TextureRegion checkboxOn;
        public TextureRegion checkboxOff;

        public CheckBoxStyle() {
        }

        public CheckBoxStyle(TextureRegion checkboxOff, TextureRegion checkboxOn, BitmapFont font, Color fontColor) {
            this.checkboxOff = checkboxOff;
            this.checkboxOn = checkboxOn;
            this.font = font;
            this.fontColor = fontColor;
        }

        public CheckBoxStyle(CheckBoxStyle style) {
            this.checkboxOff = style.checkboxOff;
            this.checkboxOn = style.checkboxOn;
            this.font = style.font;
            this.fontColor = new Color(style.fontColor);
        }
    }
}

