/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import java.util.ArrayList;
import java.util.Iterator;

public class World_Menu
extends World {
    protected App_MinerMan app_mm;
    protected BitmapFont font;
    protected Texture titleTexture;
    protected ArrayList<MenuItem> items = new ArrayList();
    public int activeId = 0;
    public World prevWorld;

    public World_Menu(App a) {
        super(a);
        this.app_mm = (App_MinerMan)a;
    }

    @Override
    public void create() {
        this.sound = new Sound[2];
        this.sound[0] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/menu_step.ogg"));
        this.sound[1] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/menu_enter.ogg"));
        this.font = new BitmapFont();
        this.titleTexture = new Texture(Gdx.files.internal("data/textures/title.png"));
    }

    @Override
    public void update() {
        if (App.keyPressed == 20) {
            boolean use = false;
            int i = 0;
            while (i < this.items.size()) {
                MenuItem item = this.items.get(i);
                if (!item.disabled) {
                    if (use) {
                        this.activeId = item.id;
                        this.playSound(0);
                        return;
                    }
                    if (item.id == this.activeId) {
                        use = true;
                    }
                }
                ++i;
            }
        } else if (App.keyPressed == 19) {
            boolean use = false;
            int i = this.items.size() - 1;
            while (i >= 0) {
                MenuItem item = this.items.get(i);
                if (!item.disabled) {
                    if (use) {
                        this.activeId = item.id;
                        this.playSound(0);
                        return;
                    }
                    if (item.id == this.activeId) {
                        use = true;
                    }
                }
                --i;
            }
        } else if (App.keyPressed == 66 || App.keyPressed == 62) {
            this.playSound(1);
            this.onEnter();
        }
    }

    public void renderMenu(float x, float y) {
        Iterator<MenuItem> it = this.items.iterator();
        int c = 0;
        while (it.hasNext()) {
            MenuItem item = it.next();
            if (this.activeId == item.id) {
                this.font.setColor(1.0f, 1.0f, 0.5f, 1.0f);
            } else if (item.disabled) {
                this.font.setColor(0.8f, 0.7f, 0.5f, 0.5f);
            } else {
                this.font.setColor(0.8f, 0.7f, 0.5f, 1.0f);
            }
            this.font.draw(this.spriteBatch, item.name, x, y - (float)(c * 18));
            ++c;
        }
    }

    public void onEnter() {
    }
}

