/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.graphics.g2d.Animation;

public class Entity_Fireball
extends GameEntity {
    private GameSprite sprite;
    private Animation anim;
    private float animTime;
    private float waitTime;
    private float speedY;
    private float y;
    private float startSpeedY = 20.0f;
    private float waitMaxTime = 1.0f;
    private boolean start;

    public Entity_Fireball(World w) {
        super(w);
        this.block = false;
        this.start = false;
    }

    public void setSpeed(float s) {
        this.startSpeedY = s;
    }

    public void setWaitTime(float t) {
        this.waitMaxTime = t;
    }

    public void create() {
        this.sprite = new GameSprite(this.game.objectsTRegion[10][0]);
        this.sprite.setPosition(0.0f, -20.0f);
        this.addSprite(this.sprite);
        this.animTime = (float)Math.random();
        this.anim = new Animation(0.07f, this.game.objectsTRegion[10][0], this.game.objectsTRegion[10][1], this.game.objectsTRegion[10][2], this.game.objectsTRegion[10][3]);
        this.speedY = this.startSpeedY;
        this.y = this.position.y;
        this.waitTime = this.waitMaxTime;
    }

    @Override
    public void update() {
        if (this.waitTime > 0.0f) {
            this.waitTime -= this.world.app.getDeltaTime();
            return;
        }
        if (!this.start) {
            this.game.playSound(7);
            this.start = true;
        }
        if (this.getDistanceToPlayer() < 16.0f) {
            this.user.hit(1);
        }
        this.animTime += this.world.app.getDeltaTime();
        this.sprite.setRegion(this.anim.getKeyFrame(this.animTime, true));
        this.speedY -= 2.0f;
        this.position.y += this.speedY;
        if (this.position.y < this.y) {
            this.position.y = this.y;
            this.speedY = this.startSpeedY;
            this.waitTime = this.waitMaxTime;
            this.start = false;
        }
        this.sprite.setScale(1.0f, this.speedY > 0.0f ? 1 : -1);
        super.update();
    }
}

