/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;

public class Entity {
    public static final int STATE_STAND = 0;
    public static final int STATE_MOVING = 1;
    protected World world;
    public Vector2 position;
    public Vector2 oldPosition;
    public Vector2 size;
    protected ArrayList<Sprite> sprites;
    protected ArrayList<Vector2> spritesPos;
    protected boolean block;
    protected boolean item;
    protected boolean shotBlock;
    protected boolean shot;
    protected boolean seeBlock;
    protected boolean enemy;
    protected Entity except;
    protected Entity clipperEntity;
    protected int clipperGrid;
    protected boolean useable;
    protected int state;
    protected int oldState;
    protected float dt;
    protected Vector2 targetPos = new Vector2();
    protected Vector2 moveDir = new Vector2();
    protected Vector2 moveSgn = new Vector2();
    protected float moveEase;
    protected float moveTime;
    protected int moveClipUseGrid = 0;
    Vector2 minD;

    public Entity(World w) {
        this.world = w;
        this.position = new Vector2();
        this.oldPosition = new Vector2();
        this.sprites = new ArrayList();
        this.spritesPos = new ArrayList();
        this.size = new Vector2();
        this.item = false;
        this.block = true;
        this.shot = false;
        this.shotBlock = true;
        this.seeBlock = false;
        this.minD = new Vector2();
        this.moveClipUseGrid = 0;
    }

    public void setState(int s) {
        this.oldState = this.state;
        this.state = s;
    }

    public void setBlock(boolean b) {
        this.block = b;
    }

    public void setClipExcept(Entity e) {
        this.except = e;
    }

    public boolean isShot() {
        return this.shot;
    }

    public World getWorld() {
        return this.world;
    }

    public void init() {
    }

    protected void onMoveClipped() {
    }

    public boolean isEnemy() {
        return this.enemy;
    }

    public void addSprite(GameSprite s) {
        Vector2 pos = new Vector2(s.getX(), s.getY());
        this.spritesPos.add(pos);
        s.setPosition(this.position.x + pos.x, this.position.y + pos.y);
        this.world.addSprite(s);
        this.sprites.add(s);
    }

    public void removeSprite(Sprite s) {
        int size = this.sprites.size();
        int i = 0;
        while (i < size) {
            if (this.sprites.get(i) == s) {
                this.spritesPos.remove(i);
                break;
            }
            ++i;
        }
        this.sprites.remove(s);
        this.world.removeSprite(s);
    }

    public void moveTo(Vector2 t, float sp, float e) {
        this.setState(1);
        this.moveTime = 0.0f;
        this.moveEase = e;
        this.targetPos.set(t);
        this.moveDir.set(this.targetPos);
        this.moveDir.sub(this.position).nor();
        this.moveDir.x *= sp;
        this.moveDir.y *= sp;
        this.moveSgn.set(Math.signum(this.position.x - t.x), Math.signum(this.position.y - t.y));
    }

    public boolean use(Entity e) {
        return false;
    }

    public boolean isUseable() {
        return this.useable;
    }

    public boolean isBlock() {
        return this.block;
    }

    public void update() {
        switch (this.state) {
            case 1: {
                this.moveTime = (1.0f + this.moveEase) * this.dt;
                this.moveEase += this.moveEase;
                this.clipperEntity = null;
                this.position.x += this.moveTime * this.moveDir.x;
                this.clipX();
                this.position.y += this.moveTime * this.moveDir.y;
                if (this.clipperEntity != null) {
                    this.onMoveClipped();
                }
                if (Math.signum(this.position.x - this.targetPos.x) == this.moveSgn.x && Math.signum(this.position.y - this.targetPos.y) == this.moveSgn.y) break;
                this.setState(0);
                this.position.set(this.targetPos);
            }
        }
        if (!this.oldPosition.equals(this.position)) {
            this.updateSpritesPosition();
        }
        this.oldPosition.set(this.position);
    }

    public void updateSpritesPosition() {
        int size = this.sprites.size();
        int i = 0;
        while (i < size) {
            Sprite s = this.sprites.get(i);
            Vector2 p = this.spritesPos.get(i);
            s.setPosition(this.position.x + p.x, this.position.y + p.y);
            ++i;
        }
    }

    public boolean clipX() {
        float s = (16.0f - this.size.x) / 3.0f;
        if (this.oldPosition.x == this.position.x) {
            return false;
        }
        if (this.moveClipUseGrid != 0) {
            float x1 = 0.0f;
            float y1 = 0.0f;
            float x2 = 0.0f;
            float y2 = -1.0f;
            if (this.oldPosition.x > this.position.x) {
                y1 = (int)(this.position.y / 16.0f);
                y2 = (int)(this.position.y / 16.0f + 0.99f);
                x1 = this.position.x + s;
                x2 = (float)((int)(x1 / 16.0f + 1.0f) * 16) - s;
            } else if (this.oldPosition.x < this.position.x) {
                y1 = (int)(this.position.y / 16.0f);
                y2 = (int)(this.position.y / 16.0f + 0.99f);
                x1 = this.position.x + s + this.size.x;
                x2 = (float)((int)(x1 / 16.0f - 1.0f) * 16) + (16.0f - this.size.x - s);
            }
            if (y2 < y1) {
                y2 = y1;
            }
            Grid grid = this.world.getGrid();
            int i = (int)y1;
            while ((float)i <= y2) {
                int x;
                int n = x = x1 < 0.0f ? -1 : (int)(x1 / 16.0f);
                if (grid.is(x, i, this.moveClipUseGrid)) {
                    this.position.x = x2;
                    this.clipperGrid = grid.get((int)(x1 / 16.0f), i);
                    return true;
                }
                ++i;
            }
        }
        if (!this.block) {
            return false;
        }
        boolean ret = false;
        ArrayList<Entity> entities = this.world.getEntityManager().entities;
        int size = entities.size();
        int i = 0;
        while (i < size) {
            Entity e = entities.get(i);
            if (e != this && e != this.except && e.block && this.checkClipX(e, 0)) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    protected boolean checkClipX(Entity e, int c) {
        Vector2 p = e.position;
        this.minD.set(e.size.x / 2.0f + this.size.x / 2.0f, e.size.y / 2.0f + this.size.y / 2.0f);
        if (Math.abs(p.x - this.position.x) < this.minD.x && Math.abs(p.y - this.position.y) < this.minD.y) {
            this.position.x = p.x < this.position.x ? p.x + this.minD.x + 1.0E-4f : p.x - this.minD.x - 1.0E-4f;
            this.clipperEntity = e;
            return true;
        }
        return false;
    }

    public boolean clipY() {
        return this.clipY(true);
    }

    public boolean clipY(boolean useLadder) {
        float s = (16.0f - this.size.x) / 3.0f;
        if (this.oldPosition.y == this.position.y) {
            return false;
        }
        if (this.moveClipUseGrid != 0) {
            float x1 = 0.0f;
            float y1 = 0.0f;
            float x2 = 0.0f;
            float y2 = 0.0f;
            y1 = 0.0f;
            y2 = -1.0f;
            if (this.oldPosition.y > this.position.y) {
                x1 = (int)((this.position.x + s) / 16.0f);
                x2 = (int)((this.position.x + s + this.size.x - 1.0f) / 16.0f);
                y1 = y1 < 0.0f ? -1 : (int)(this.position.y / 16.0f);
                y2 = y1 + 1.0f;
            } else if (this.oldPosition.y < this.position.y) {
                x1 = (int)((this.position.x + s) / 16.0f);
                x2 = (int)((this.position.x + s + this.size.x - 1.0f) / 16.0f);
                y1 = (int)(this.position.y / 16.0f) + 1;
                y2 = y1 - 0.9999f;
            }
            if (x2 < x1) {
                x2 = x1;
            }
            float offset = this.position.y - (float)((int)(this.position.y / 16.0f) * 16);
            float speed = Math.abs(this.oldPosition.y - this.position.y);
            Grid grid = this.world.getGrid();
            int i = (int)x1;
            while (i <= (int)x2) {
                if (grid.is(i, (int)y1, this.moveClipUseGrid)) {
                    this.position.y = y2 * 16.0f;
                    this.clipperGrid = grid.get(i, (int)y1);
                    return true;
                }
                if (useLadder && this.oldPosition.y > this.position.y && grid.is(i, (int)y1, 4) && (offset > 10.0f || speed > 6.0f)) {
                    this.position.y = y2 * 16.0f;
                    return true;
                }
                ++i;
            }
        }
        if (!this.block) {
            return false;
        }
        boolean ret = false;
        ArrayList<Entity> entities = this.world.getEntityManager().entities;
        int size = entities.size();
        int i = 0;
        while (i < size) {
            Entity e = entities.get(i);
            if (e != this && e != this.except && e.block && this.checkClipY(e, 0)) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    public boolean isShotBlock() {
        return this.shotBlock;
    }

    public void remove() {
        int size = this.sprites.size();
        int i = 0;
        while (i < size) {
            this.spritesPos.remove(i);
            this.world.removeSprite(this.sprites.get(i));
            ++i;
        }
        this.sprites.clear();
    }

    protected boolean checkClipY(Entity e, int c) {
        Vector2 p = e.position;
        this.minD.set(e.size.x / 2.0f + this.size.x / 2.0f, e.size.y / 2.0f + this.size.y / 2.0f);
        if (Math.abs(p.x - this.position.x) < this.minD.x && Math.abs(p.y - this.position.y) < this.minD.y) {
            this.position.y = p.y < this.position.y ? p.y + this.minD.y + 1.0E-4f : p.y - this.minD.y - 1.0E-4f;
            this.clipperEntity = e;
            return true;
        }
        return false;
    }

    public void hit(int power, Entity e) {
    }

    public void dispose() {
    }
}

