/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Config_Desktop
extends Config {
    private String homePath;

    public Config_Desktop(String name) {
        this.homePath = String.valueOf(System.getProperty("user.home")) + "/.dynArt/" + name;
    }

    @Override
    public void load() {
        this.props.put("screen_width", "800");
        this.props.put("screen_height", "600");
        this.props.put("fullscreen", "0");
        this.props.put("desktop", "1");
        this.props.put("hearth", "3");
        this.props.put("live", "3");
        this.props.put("level", "0");
        this.props.put("music", "1");
        this.props.put("sound", "1");
        File f = new File(String.valueOf(this.homePath) + "/desktop.ini");
        if (f.exists()) {
            try {
                FileInputStream is = new FileInputStream(f);
                this.props.load(is);
                is.close();
                return;
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public void save() {
        File f = new File(this.homePath);
        if (!f.exists() && !f.mkdirs()) {
            System.out.println("Can't create directory: " + this.homePath);
            return;
        }
        f = new File(String.valueOf(this.homePath) + "/desktop.ini");
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream os = new FileOutputStream(f);
            this.props.store(os, "MinerMan configuration");
            os.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

