/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.math.Vector2;
import java.util.HashMap;

public class App
implements ApplicationListener,
InputProcessor {
    protected World world;
    protected Config config;
    protected float maxDeltaTime = 1.0f;
    protected float time;
    private static HashMap<Integer, Boolean> keyStatus = new HashMap();
    public static Vector2 mousePos = new Vector2();
    public static Vector2 lastMousePos = new Vector2();
    public static Vector2 mouseMove = new Vector2();
    public static boolean isMouseMoved;
    public static boolean isMouseDown;
    public static AssetManager assets;
    public static int keyPressed;
    protected Music music;
    protected String musicPath = "";

    static {
        assets = new AssetManager();
    }

    public App(Config c, float mdt) {
        this.config = c;
        this.maxDeltaTime = mdt;
    }

    @Override
    public void create() {
        Gdx.graphics.setVSync(false);
    }

    public void setWorld(World w) {
        this.world = w;
    }

    public World getWorld() {
        return this.world;
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public void render() {
        if (this.world == null) {
            return;
        }
        this.time += Gdx.graphics.getDeltaTime();
        mouseMove.set(0.0f, 0.0f);
        isMouseMoved = false;
        lastMousePos.set(mousePos);
        mousePos.set(Gdx.input.getX(), Gdx.input.getY());
        if (App.lastMousePos.x != App.mousePos.x || App.lastMousePos.y != App.mousePos.y) {
            mouseMove.set(App.lastMousePos.x - App.mousePos.x, App.lastMousePos.y - App.mousePos.y);
            isMouseMoved = true;
        }
        if (this.time > 0.0337f) {
            this.world.update();
            this.time = 0.0f;
            keyPressed = 0;
        } else {
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        this.world.render();
    }

    @Override
    public void dispose() {
        this.config.save();
        if (this.music != null) {
            this.music.dispose();
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void resize(int width, int height) {
        if (this.world == null) {
            return;
        }
        this.world.resize(width, height);
    }

    @Override
    public void resume() {
    }

    @Override
    public boolean keyDown(int key) {
        if (!App.isKeyDown(key)) {
            keyPressed = key;
        }
        Integer i = new Integer(key);
        keyStatus.put(i, new Boolean(true));
        return false;
    }

    @Override
    public boolean keyUp(int key) {
        Integer i = new Integer(key);
        if (keyStatus.containsKey(i)) {
            keyStatus.put(i, new Boolean(false));
        }
        return false;
    }

    public static boolean isKeyDown(int key) {
        Integer i = new Integer(key);
        if (keyStatus.containsKey(i)) {
            return keyStatus.get(i);
        }
        return false;
    }

    @Override
    public boolean keyTyped(char key) {
        return false;
    }

    @Override
    public boolean scrolled(int arg0) {
        return false;
    }

    @Override
    public boolean touchDown(int x, int y, int pointer, int button) {
        isMouseDown = true;
        return false;
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        return false;
    }

    @Override
    public boolean touchMoved(int x, int y) {
        return false;
    }

    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        isMouseDown = false;
        return false;
    }

    public float getDeltaTime() {
        float dt = this.time;
        if (dt > this.maxDeltaTime) {
            dt = this.maxDeltaTime;
        }
        return dt;
    }

    public void setMusicVolume(float v) {
        this.music.setVolume(v);
    }

    public void playMusic(String path) {
        path = path.replace("/textures/", "/musics/");
        if ((path = path.replace(".png", ".ogg")).equals(this.musicPath)) {
            return;
        }
        this.musicPath = path;
        if (this.music != null) {
            if (this.music.isPlaying()) {
                this.music.stop();
            }
            this.music.dispose();
        }
        this.music = Gdx.audio.newMusic(Gdx.files.internal(path));
        this.music.setLooping(true);
        this.music.setVolume(0.4f);
        this.music.play();
        if (this.config.getInt("music", 0) == 0) {
            this.setMusicVolume(0.0f);
        }
    }
}

