/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.LibgdxToolkit;

public class Stack
extends WidgetGroup {
    public Stack() {
        this(null);
    }

    public Stack(String name) {
        super(name);
        this.transform = false;
        this.width = 150.0f;
        this.height = 150.0f;
    }

    @Override
    public void layout() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Actor child = (Actor)this.children.get(i);
            child.x = 0.0f;
            child.y = 0.0f;
            child.width = this.width;
            child.height = this.height;
            if (!(child instanceof Layout)) continue;
            Layout layout = (Layout)((Object)child);
            layout.invalidate();
            layout.validate();
        }
    }

    @Override
    public float getPrefWidth() {
        float width = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            width = Math.max(width, (float)LibgdxToolkit.instance.getPrefWidth((Actor)this.children.get(i)));
        }
        return width * this.scaleX;
    }

    @Override
    public float getPrefHeight() {
        float height = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            height = Math.max(height, (float)LibgdxToolkit.instance.getPrefHeight((Actor)this.children.get(i)));
        }
        return height * this.scaleY;
    }

    @Override
    public float getMaxWidth() {
        if (this.children.isEmpty()) {
            return 0.0f;
        }
        float width = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            int maxWidth = LibgdxToolkit.instance.getMaxHeight((Actor)this.children.get(i));
            if (maxWidth <= 0) continue;
            width = width == 0.0f ? (float)maxWidth : Math.min(width, (float)maxWidth);
        }
        return width * this.scaleX;
    }

    @Override
    public float getMaxHeight() {
        if (this.children.isEmpty()) {
            return 0.0f;
        }
        float height = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            int maxHeight = LibgdxToolkit.instance.getMaxHeight((Actor)this.children.get(i));
            if (maxHeight <= 0) continue;
            height = height == 0.0f ? (float)maxHeight : Math.min(height, (float)maxHeight);
        }
        return height * this.scaleY;
    }

    @Override
    public float getMinWidth() {
        float width = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            width = Math.max(width, (float)LibgdxToolkit.instance.getMinWidth((Actor)this.children.get(i)));
        }
        return width * this.scaleX;
    }

    @Override
    public float getMinHeight() {
        float height = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            height = Math.max(height, (float)LibgdxToolkit.instance.getMinHeight((Actor)this.children.get(i)));
        }
        return height * this.scaleY;
    }
}

