/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.SelectionListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;

public class SelectBox
extends Widget {
    SelectBoxStyle style;
    String[] items;
    int selection = 0;
    private final BitmapFont.TextBounds bounds = new BitmapFont.TextBounds();
    final Vector2 screenCoords = new Vector2();
    private SelectList list = null;
    SelectionListener listener;
    private float prefWidth;
    private float prefHeight;
    final Vector2 stageCoords = new Vector2();

    public SelectBox(Skin skin) {
        this((Object[])new String[0], skin);
    }

    public SelectBox(Object[] items, Skin skin) {
        this(items, skin.getStyle(SelectBoxStyle.class), null);
    }

    public SelectBox(Object[] items, SelectBoxStyle style) {
        this(items, style, null);
    }

    public SelectBox(Object[] items, SelectBoxStyle style, String name) {
        super(name);
        this.setStyle(style);
        this.setItems(items);
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public void setStyle(SelectBoxStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        if (this.items != null) {
            this.setItems(this.items);
        } else {
            this.invalidateHierarchy();
        }
    }

    public SelectBoxStyle getStyle() {
        return this.style;
    }

    public void setItems(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("items cannot be null.");
        }
        if (!(objects instanceof String[])) {
            String[] strings = new String[objects.length];
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                strings[i] = String.valueOf(objects[i]);
            }
            objects = strings;
        }
        this.items = (String[])objects;
        NinePatch bg = this.style.background;
        BitmapFont font = this.style.font;
        this.prefHeight = Math.max(bg.getTopHeight() + bg.getBottomHeight() + font.getCapHeight() - font.getDescent() * 2.0f, bg.getTotalHeight());
        float max = 0.0f;
        for (int i = 0; i < this.items.length; ++i) {
            max = Math.max(font.getBounds((CharSequence)this.items[i]).width, max);
        }
        this.prefWidth = bg.getLeftWidth() + bg.getRightWidth() + max;
        this.invalidateHierarchy();
    }

    @Override
    public void layout() {
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        NinePatch background = this.style.background;
        BitmapFont font = this.style.font;
        Color fontColor = this.style.fontColor;
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        background.draw(batch, this.x, this.y, this.width, this.height);
        if (this.items.length > 0) {
            float availableWidth = this.width - background.getLeftWidth() - background.getRightWidth();
            int numGlyphs = font.computeVisibleGlyphs(this.items[this.selection], 0, this.items[this.selection].length(), availableWidth);
            this.bounds.set(font.getBounds(this.items[this.selection]));
            float textY = (int)(this.height / 2.0f) + (int)(this.bounds.height / 2.0f);
            font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * parentAlpha);
            font.draw(batch, this.items[this.selection], this.x + background.getLeftWidth(), this.y + textY, 0, numGlyphs);
        }
        ScissorStack.toWindowCoordinates(this.stage.getCamera(), batch.getTransformMatrix(), this.screenCoords.set(this.x, this.y));
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        if (this.list != null && this.list.parent != null) {
            this.stage.removeActor(this.list);
            return true;
        }
        this.stage.toStageCoordinates((int)this.screenCoords.x, (int)this.screenCoords.y, this.stageCoords);
        this.list = new SelectList(this.name + "-list", this.stageCoords.x, this.stageCoords.y);
        this.stage.addActor(this.list);
        this.stage.setTouchFocus(this.list, 0);
        return true;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
    }

    public void setSelectionListener(SelectionListener listener) {
        this.listener = listener;
    }

    public void setSelection(int selection) {
        this.selection = selection;
    }

    public void setSelection(String item) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].equals(item)) continue;
            this.selection = i;
        }
    }

    public int getSelectionIndex() {
        return this.selection;
    }

    public String getSelection() {
        return this.items[this.selection];
    }

    @Override
    public float getPrefWidth() {
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        return this.prefHeight;
    }

    @Override
    public void markToRemove(boolean remove) {
        super.markToRemove(remove);
        if (this.list != null) {
            this.list.markToRemove(true);
        }
    }

    public static class SelectBoxStyle {
        public NinePatch background;
        public NinePatch listBackground;
        public NinePatch listSelection;
        public BitmapFont font;
        public Color fontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public float itemSpacing = 10.0f;

        public SelectBoxStyle() {
        }

        public SelectBoxStyle(BitmapFont font, Color fontColor, NinePatch background, NinePatch listBackground, NinePatch listSelection) {
            this.background = background;
            this.listBackground = listBackground;
            this.listSelection = listSelection;
            this.font = font;
            this.fontColor.set(fontColor);
        }

        public SelectBoxStyle(SelectBoxStyle style) {
            this.background = style.background;
            this.listBackground = style.listBackground;
            this.listSelection = style.listSelection;
            this.font = style.font;
            this.fontColor.set(style.fontColor);
        }
    }

    class SelectList
    extends Actor {
        Vector2 oldScreenCoords;
        float itemHeight;
        float textOffsetX;
        float textOffsetY;
        int selected;
        boolean ownsTouch;

        public SelectList(String name, float x, float y) {
            super(name);
            this.oldScreenCoords = new Vector2();
            this.selected = SelectBox.this.selection;
            this.ownsTouch = false;
            this.x = x;
            this.width = SelectBox.this.width;
            this.height = 100.0f;
            this.oldScreenCoords.set(SelectBox.this.screenCoords);
            this.layout();
            Stage stage = SelectBox.this.getStage();
            this.y = y - this.height < 0.0f && y + SelectBox.this.height + this.height < SelectBox.this.getStage().getCamera().viewportHeight ? y + SelectBox.this.height : y - this.height;
        }

        private void layout() {
            BitmapFont font = SelectBox.this.style.font;
            NinePatch listSelection = SelectBox.this.style.listSelection;
            float prefWidth = 0.0f;
            float prefHeight = 0.0f;
            for (int i = 0; i < SelectBox.this.items.length; ++i) {
                String item = SelectBox.this.items[i];
                BitmapFont.TextBounds bounds = font.getBounds(item);
                prefWidth = Math.max(bounds.width, prefWidth);
            }
            this.itemHeight = font.getCapHeight() + -font.getDescent() * 2.0f + SelectBox.this.style.itemSpacing;
            this.itemHeight += listSelection.getTopHeight() + listSelection.getBottomHeight();
            this.itemHeight *= SelectBox.this.parent.scaleY;
            prefHeight = (float)SelectBox.this.items.length * this.itemHeight;
            this.textOffsetX = listSelection.getLeftWidth() + SelectBox.this.style.itemSpacing;
            this.textOffsetY = listSelection.getTopHeight() + -font.getDescent() + SelectBox.this.style.itemSpacing / 2.0f;
            this.width = Math.max(prefWidth += listSelection.getLeftWidth() + listSelection.getRightWidth() + 2.0f * SelectBox.this.style.itemSpacing, SelectBox.this.width);
            this.width *= SelectBox.this.parent.scaleX;
            this.height = prefHeight;
        }

        @Override
        public void draw(SpriteBatch batch, float parentAlpha) {
            NinePatch listBackground = SelectBox.this.style.listBackground;
            NinePatch listSelection = SelectBox.this.style.listSelection;
            BitmapFont font = SelectBox.this.style.font;
            Color fontColor = SelectBox.this.style.fontColor;
            batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
            listBackground.draw(batch, this.x, this.y, this.width, this.height);
            float posY = this.height;
            for (int i = 0; i < SelectBox.this.items.length; ++i) {
                if (this.selected == i) {
                    listSelection.draw(batch, this.x, this.y + posY - this.itemHeight, this.width, this.itemHeight);
                }
                font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * parentAlpha);
                font.setScale(SelectBox.this.parent.scaleX, SelectBox.this.parent.scaleY);
                font.draw(batch, SelectBox.this.items[i], this.x + this.textOffsetX, this.y + posY - this.textOffsetY);
                font.setScale(1.0f, 1.0f);
                posY -= this.itemHeight;
            }
        }

        @Override
        public boolean touchDown(float x, float y, int pointer) {
            if (pointer != 0) {
                return false;
            }
            this.ownsTouch = true;
            if (x > 0.0f && x < this.width && y > 0.0f && y < this.height) {
                this.selected = (int)((this.height - y) / this.itemHeight);
                this.selected = Math.max(0, this.selected);
                SelectBox.this.selection = this.selected = Math.min(SelectBox.this.items.length - 1, this.selected);
                if (SelectBox.this.items.length > 0 && SelectBox.this.listener != null) {
                    SelectBox.this.listener.selected(SelectBox.this, this.selected, SelectBox.this.items[this.selected]);
                }
            }
            return true;
        }

        @Override
        public void touchUp(float x, float y, int pointer) {
            if (this.stage != null && this.ownsTouch) {
                this.stage.removeActor(this);
            }
            this.ownsTouch = false;
        }

        @Override
        public void touchDragged(float x, float y, int pointer) {
        }

        @Override
        public boolean touchMoved(float x, float y) {
            if (x > 0.0f && x < this.width && y > 0.0f && y < this.height) {
                this.selected = (int)((this.height - y) / this.itemHeight);
                this.selected = Math.max(0, this.selected);
                this.selected = Math.min(SelectBox.this.items.length - 1, this.selected);
            }
            return true;
        }

        @Override
        public Actor hit(float x, float y) {
            return this;
        }

        @Override
        public void act(float delta) {
            if ((SelectBox.this.screenCoords.x != this.oldScreenCoords.x || SelectBox.this.screenCoords.y != this.oldScreenCoords.y) && this.stage != null) {
                this.stage.removeActor(this);
            }
        }
    }
}

