/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.interpolators;

import com.badlogic.gdx.scenes.scene2d.Interpolator;
import com.badlogic.gdx.utils.Pool;

public class DecelerateInterpolator
implements Interpolator {
    private static final float DEFAULT_FACTOR = 1.0f;
    private static final Pool<DecelerateInterpolator> pool = new Pool<DecelerateInterpolator>(4, 100){

        @Override
        protected DecelerateInterpolator newObject() {
            return new DecelerateInterpolator();
        }
    };
    private float factor;
    private double doubledFactor;

    DecelerateInterpolator() {
    }

    public static DecelerateInterpolator $(float factor) {
        DecelerateInterpolator inter = pool.obtain();
        inter.factor = factor;
        inter.doubledFactor = factor * 2.0f;
        return inter;
    }

    public static DecelerateInterpolator $() {
        return DecelerateInterpolator.$(1.0f);
    }

    @Override
    public void finished() {
        pool.free(this);
    }

    @Override
    public float getInterpolation(float input) {
        if (this.factor == 1.0f) {
            return 1.0f - (1.0f - input) * (1.0f - input);
        }
        return (float)(1.0 - Math.pow(1.0f - input, this.doubledFactor));
    }

    @Override
    public Interpolator copy() {
        return DecelerateInterpolator.$(this.factor);
    }
}

