/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.AnimationAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class MoveTo
extends AnimationAction {
    private static final ActionResetingPool<MoveTo> pool = new ActionResetingPool<MoveTo>(4, 100){

        @Override
        protected MoveTo newObject() {
            return new MoveTo();
        }
    };
    protected float x;
    protected float y;
    protected float startX;
    protected float startY;
    protected float deltaX;
    protected float deltaY;

    public static MoveTo $(float x, float y, float duration) {
        MoveTo action = (MoveTo)pool.obtain();
        action.x = x;
        action.y = y;
        action.duration = duration;
        action.invDuration = 1.0f / duration;
        return action;
    }

    @Override
    public void setTarget(Actor actor) {
        this.target = actor;
        this.startX = this.target.x;
        this.startY = this.target.y;
        this.deltaX = this.x - this.target.x;
        this.deltaY = this.y - this.target.y;
        this.taken = 0.0f;
        this.done = false;
    }

    @Override
    public void act(float delta) {
        float alpha = this.createInterpolatedAlpha(delta);
        if (this.done) {
            this.target.x = this.x;
            this.target.y = this.y;
        } else {
            this.target.x = this.startX + this.deltaX * alpha;
            this.target.y = this.startY + this.deltaY * alpha;
        }
    }

    @Override
    public void finish() {
        super.finish();
        pool.free(this);
    }

    @Override
    public Action copy() {
        MoveTo moveTo = MoveTo.$(this.x, this.y, this.duration);
        if (this.interpolator != null) {
            moveTo.setInterpolator(this.interpolator.copy());
        }
        return moveTo;
    }
}

