/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.AnimationAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class FadeTo
extends AnimationAction {
    private static final ActionResetingPool<FadeTo> pool = new ActionResetingPool<FadeTo>(4, 100){

        @Override
        protected FadeTo newObject() {
            return new FadeTo();
        }
    };
    protected float toAlpha = 0.0f;
    protected float startAlpha;
    protected float deltaAlpha = 0.0f;

    public static FadeTo $(float alpha, float duration) {
        FadeTo action = (FadeTo)pool.obtain();
        action.toAlpha = Math.min(Math.max(alpha, 0.0f), 1.0f);
        action.duration = duration;
        action.invDuration = 1.0f / duration;
        return action;
    }

    @Override
    public void setTarget(Actor actor) {
        this.target = actor;
        this.startAlpha = this.target.color.a;
        this.deltaAlpha = this.toAlpha - this.target.color.a;
        this.taken = 0.0f;
        this.done = false;
    }

    @Override
    public void act(float delta) {
        float alpha = this.createInterpolatedAlpha(delta);
        if (this.done) {
            this.target.color.a = this.toAlpha;
        } else {
            float val = this.startAlpha + this.deltaAlpha * alpha;
            this.target.color.a = Math.min(Math.max(val, 0.0f), 1.0f);
        }
    }

    @Override
    public void finish() {
        super.finish();
        pool.free(this);
    }

    @Override
    public Action copy() {
        FadeTo fadeTo = FadeTo.$(this.toAlpha, this.duration);
        if (this.interpolator != null) {
            fadeTo.setInterpolator(this.interpolator.copy());
        }
        return fadeTo;
    }
}

