/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer10;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class ShapeRenderer {
    ImmediateModeRenderer renderer;
    boolean matrixDirty = false;
    Matrix4 projView = new Matrix4();
    Matrix4 transform = new Matrix4();
    Matrix4 combined = new Matrix4();
    Matrix4 tmp = new Matrix4();
    Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    ShapeType currType = null;

    public ShapeRenderer() {
        this(5000);
    }

    public ShapeRenderer(int maxVertices) {
        this.renderer = Gdx.graphics.isGL20Available() ? new ImmediateModeRenderer20(maxVertices, false, true, 0) : new ImmediateModeRenderer10(maxVertices);
        this.projView.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.matrixDirty = true;
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
    }

    public void setProjectionMatrix(Matrix4 matrix) {
        this.projView.set(matrix);
        this.matrixDirty = true;
    }

    public void setTransformMatrix(Matrix4 matrix) {
        this.transform.set(matrix);
        this.matrixDirty = true;
    }

    public void identity() {
        this.transform.idt();
        this.matrixDirty = true;
    }

    public void translate(float x, float y, float z) {
        this.transform.translate(x, y, z);
        this.matrixDirty = true;
    }

    public void rotate(float axisX, float axisY, float axisZ, float angle) {
        this.transform.rotate(axisX, axisY, axisZ, angle);
        this.matrixDirty = true;
    }

    public void scale(float scaleX, float scaleY, float scaleZ) {
        this.transform.scale(scaleX, scaleY, scaleZ);
        this.matrixDirty = true;
    }

    public void begin(ShapeType type) {
        if (this.currType != null) {
            throw new GdxRuntimeException("Call end() before beginning a new shape batch");
        }
        this.currType = type;
        if (this.matrixDirty) {
            this.combined.set(this.projView);
            Matrix4.mul(this.combined.val, this.transform.val);
            this.matrixDirty = false;
        }
        this.renderer.begin(this.combined, this.currType.getGlType());
    }

    public void point(float x, float y, float z) {
        if (this.currType != ShapeType.Point) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Point)");
        }
        this.checkDirty();
        this.checkFlush(1);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z);
    }

    public void line(float x, float y, float z, float x2, float y2, float z2) {
        if (this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(2);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x2, y2, z2);
    }

    public void line(float x, float y, float x2, float y2) {
        if (this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(2);
        if (this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x2, y2, 0.0f);
    }

    public void rect(float x, float y, float width, float height) {
        if (this.currType != ShapeType.Rectangle) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Rectangle)");
        }
        this.checkDirty();
        this.checkFlush(8);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, 0.0f);
    }

    public void filledRect(float x, float y, float width, float height) {
        if (this.currType != ShapeType.FilledRectangle) {
            throw new GdxRuntimeException("Must call begin(ShapeType.FilledRectangle)");
        }
        this.checkDirty();
        this.checkFlush(8);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, 0.0f);
    }

    public void filledRect(float x, float y, float width, float height, Color c1, Color c2, Color c3, Color c4) {
        if (this.currType != ShapeType.FilledRectangle) {
            throw new GdxRuntimeException("Must call begin(ShapeType.FilledRectangle)");
        }
        this.checkDirty();
        this.checkFlush(8);
        this.renderer.color(c1.r, c1.g, c1.b, c1.a);
        this.renderer.vertex(x, y, 0.0f);
        this.renderer.color(c2.r, c2.g, c2.b, c2.a);
        this.renderer.vertex(x + width, y, 0.0f);
        this.renderer.color(c3.r, c3.g, c3.b, c3.a);
        this.renderer.vertex(x + width, y + height, 0.0f);
        this.renderer.color(c3.r, c3.g, c3.b, c3.a);
        this.renderer.vertex(x + width, y + height, 0.0f);
        this.renderer.color(c4.r, c4.g, c4.b, c4.a);
        this.renderer.vertex(x, y + height, 0.0f);
        this.renderer.color(c1.r, c1.g, c1.b, c1.a);
        this.renderer.vertex(x, y, 0.0f);
    }

    public void box(float x, float y, float z, float width, float height, float depth) {
        if (this.currType != ShapeType.Box) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Box)");
        }
        this.checkDirty();
        this.checkFlush(16);
        depth = -depth;
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z + depth);
    }

    public void circle(float x, float y, float radius) {
        this.circle(x, y, radius, (int)(6.0f * (float)Math.cbrt(radius)));
    }

    public void circle(float x, float y, float radius, int segments) {
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be >= 0.");
        }
        if (this.currType != ShapeType.Circle) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Circle)");
        }
        this.checkDirty();
        this.checkFlush(segments * 2 + 2);
        float angle = 6.283185f / (float)segments;
        float cos = MathUtils.cos(angle);
        float sin = MathUtils.sin(angle);
        float cx = radius;
        float cy = 0.0f;
        for (int i = 0; i < segments; ++i) {
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
            float temp = cx;
            cx = cos * cx - sin * cy;
            cy = sin * temp + cos * cy;
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
        }
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + cx, y + cy, 0.0f);
        float temp = cx;
        cx = radius;
        cy = 0.0f;
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + cx, y + cy, 0.0f);
    }

    public void filledCircle(float x, float y, float radius) {
        this.filledCircle(x, y, radius, (int)(4.0f * (float)Math.sqrt(radius)));
    }

    public void filledCircle(float x, float y, float radius, int segments) {
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be >= 0.");
        }
        if (this.currType != ShapeType.FilledCircle) {
            throw new GdxRuntimeException("Must call begin(ShapeType.FilledCircle)");
        }
        this.checkDirty();
        this.checkFlush(segments * 3 + 3);
        int inc = 360 / segments;
        float angle = 6.283185f / (float)segments;
        float cos = MathUtils.cos(angle);
        float sin = MathUtils.sin(angle);
        float cx = radius;
        float cy = 0.0f;
        --segments;
        for (int i = 0; i < segments; ++i) {
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
            float temp = cx;
            cx = cos * cx - sin * cy;
            cy = sin * temp + cos * cy;
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
        }
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + cx, y + cy, 0.0f);
        cx = radius;
        cy = 0.0f;
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + cx, y + cy, 0.0f);
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.currType != ShapeType.Triangle) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Triangle)");
        }
        this.checkDirty();
        this.checkFlush(6);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x1, y1, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x2, y2, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x2, y2, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x3, y3, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x3, y3, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x1, y1, 0.0f);
    }

    public void filledTriangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.currType != ShapeType.FilledTriangle) {
            throw new GdxRuntimeException("Must call begin(ShapeType.FilledTriangle)");
        }
        this.checkDirty();
        this.checkFlush(3);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x1, y1, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x2, y2, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x3, y3, 0.0f);
    }

    private void checkDirty() {
        if (!this.matrixDirty) {
            return;
        }
        ShapeType type = this.currType;
        this.end();
        this.begin(type);
    }

    private void checkFlush(int newVertices) {
        if (this.renderer.getMaxVertices() - this.renderer.getNumVertices() >= newVertices) {
            return;
        }
        ShapeType type = this.currType;
        this.end();
        this.begin(type);
    }

    public void end() {
        this.renderer.end();
        this.currType = null;
    }

    public void flush() {
        ShapeType type = this.currType;
        this.end();
        this.begin(type);
    }

    public void dispose() {
        this.renderer.dispose();
    }

    public static enum ShapeType {
        Point(0),
        Line(1),
        Rectangle(1),
        FilledRectangle(4),
        Box(1),
        Circle(1),
        FilledCircle(4),
        Triangle(1),
        FilledTriangle(4);

        private final int glType;

        private ShapeType(int glType) {
            this.glType = glType;
        }

        public int getGlType() {
            return this.glType;
        }
    }
}

