/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.md5;

import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Animation;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Joints;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Mesh;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Model;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MD5Loader {
    static MD5Quaternion thisOrient = new MD5Quaternion();
    static MD5Quaternion parentOrient = new MD5Quaternion();
    static Vector3 parentPos = new Vector3();

    public static MD5Model loadModel(InputStream in, boolean allocateNormals) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in), 1024);
        MD5Model model = new MD5Model();
        ArrayList<String> tokens = new ArrayList<String>(10);
        MD5Quaternion quat = new MD5Quaternion();
        int floatsPerVert = 4;
        if (allocateNormals) {
            floatsPerVert += 3;
        }
        int floatsPerWeight = 5;
        if (allocateNormals) {
            floatsPerWeight += 3;
        }
        try {
            String line;
            int currMesh = 0;
            while ((line = reader.readLine()) != null) {
                int version;
                MD5Loader.tokenize(line, tokens);
                if (tokens.size() == 0) continue;
                if (((String)tokens.get(0)).equals("MD5Version") && (version = MD5Loader.parseInt((String)tokens.get(1))) != 10) {
                    throw new IllegalArgumentException("Not a valid MD5 file, go version " + version + ", need 10");
                }
                if (((String)tokens.get(0)).equals("numJoints")) {
                    int numJoints = MD5Loader.parseInt((String)tokens.get(1));
                    model.baseSkeleton = new MD5Joints();
                    model.baseSkeleton.names = new String[numJoints];
                    model.baseSkeleton.numJoints = numJoints;
                    model.baseSkeleton.joints = new float[numJoints * 8];
                }
                if (((String)tokens.get(0)).equals("numMeshes")) {
                    int numMeshes = MD5Loader.parseInt((String)tokens.get(1));
                    model.meshes = new MD5Mesh[numMeshes];
                }
                if (((String)tokens.get(0)).equals("joints")) {
                    for (int i = 0; i < model.baseSkeleton.numJoints; ++i) {
                        line = reader.readLine();
                        MD5Loader.tokenize(line, tokens);
                        if (tokens.size() == 0) {
                            --i;
                            continue;
                        }
                        int jointIdx = i << 3;
                        model.baseSkeleton.names[i] = (String)tokens.get(0);
                        model.baseSkeleton.joints[jointIdx] = MD5Loader.parseInt((String)tokens.get(1));
                        model.baseSkeleton.joints[jointIdx + 1] = MD5Loader.parseFloat((String)tokens.get(3));
                        model.baseSkeleton.joints[jointIdx + 2] = MD5Loader.parseFloat((String)tokens.get(4));
                        model.baseSkeleton.joints[jointIdx + 3] = MD5Loader.parseFloat((String)tokens.get(5));
                        quat.x = MD5Loader.parseFloat((String)tokens.get(8));
                        quat.y = MD5Loader.parseFloat((String)tokens.get(9));
                        quat.z = MD5Loader.parseFloat((String)tokens.get(10));
                        quat.computeW();
                        model.baseSkeleton.joints[jointIdx + 4] = quat.x;
                        model.baseSkeleton.joints[jointIdx + 5] = quat.y;
                        model.baseSkeleton.joints[jointIdx + 6] = quat.z;
                        model.baseSkeleton.joints[jointIdx + 7] = quat.w;
                    }
                }
                if (!((String)tokens.get(0)).equals("mesh") || !((String)tokens.get(1)).equals("{")) continue;
                MD5Mesh mesh = new MD5Mesh();
                mesh.floatsPerVertex = floatsPerVert;
                mesh.floatsPerWeight = floatsPerWeight;
                model.meshes[currMesh++] = mesh;
                int vertIndex = 0;
                int triIndex = 0;
                int weightIndex = 0;
                while (!line.contains("}")) {
                    int idx;
                    line = reader.readLine();
                    MD5Loader.tokenize(line, tokens);
                    if (tokens.size() == 0) continue;
                    if (((String)tokens.get(0)).equals("shader")) {
                        mesh.shader = (String)tokens.get(1);
                    }
                    if (((String)tokens.get(0)).equals("numverts")) {
                        mesh.numVertices = MD5Loader.parseInt((String)tokens.get(1));
                        mesh.vertices = new float[mesh.numVertices * floatsPerVert];
                    }
                    if (((String)tokens.get(0)).equals("numtris")) {
                        mesh.indices = new short[MD5Loader.parseInt((String)tokens.get(1)) * 3];
                        mesh.numTriangles = mesh.indices.length / 3;
                    }
                    if (((String)tokens.get(0)).equals("numweights")) {
                        mesh.numWeights = MD5Loader.parseInt((String)tokens.get(1));
                        mesh.weights = new float[mesh.numWeights * floatsPerWeight];
                    }
                    if (((String)tokens.get(0)).equals("vert")) {
                        vertIndex = MD5Loader.parseInt((String)tokens.get(1));
                        idx = vertIndex * floatsPerVert;
                        mesh.vertices[idx++] = MD5Loader.parseFloat((String)tokens.get(3));
                        mesh.vertices[idx++] = MD5Loader.parseFloat((String)tokens.get(4));
                        mesh.vertices[idx++] = MD5Loader.parseFloat((String)tokens.get(6));
                        mesh.vertices[idx++] = MD5Loader.parseFloat((String)tokens.get(7));
                        if (allocateNormals) {
                            mesh.vertices[idx++] = 0.0f;
                            mesh.vertices[idx++] = 0.0f;
                            mesh.vertices[idx++] = 0.0f;
                        }
                    }
                    if (((String)tokens.get(0)).equals("tri")) {
                        triIndex = MD5Loader.parseInt((String)tokens.get(1));
                        idx = triIndex * 3;
                        mesh.indices[idx++] = Short.parseShort((String)tokens.get(2));
                        mesh.indices[idx++] = Short.parseShort((String)tokens.get(3));
                        mesh.indices[idx++] = Short.parseShort((String)tokens.get(4));
                    }
                    if (!((String)tokens.get(0)).equals("weight")) continue;
                    weightIndex = MD5Loader.parseInt((String)tokens.get(1));
                    idx = weightIndex * floatsPerWeight;
                    mesh.weights[idx++] = MD5Loader.parseInt((String)tokens.get(2));
                    mesh.weights[idx++] = MD5Loader.parseFloat((String)tokens.get(3));
                    mesh.weights[idx++] = MD5Loader.parseFloat((String)tokens.get(5));
                    mesh.weights[idx++] = MD5Loader.parseFloat((String)tokens.get(6));
                    mesh.weights[idx++] = MD5Loader.parseFloat((String)tokens.get(7));
                }
            }
            return model;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static MD5Animation loadAnimation(InputStream in) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        ArrayList<String> tokens = new ArrayList<String>();
        MD5Animation animation = new MD5Animation();
        try {
            String line;
            JointInfo[] jointInfos = null;
            BaseFrameJoint[] baseFrame = null;
            float[] animFrameData = null;
            while ((line = reader.readLine()) != null) {
                int i;
                int i2;
                MD5Loader.tokenize(line, tokens);
                if (tokens.size() == 0) continue;
                if (((String)tokens.get(0)).equals("MD5Version") && !((String)tokens.get(1)).equals("10")) {
                    throw new IllegalArgumentException("Not a valid MD5 animation file, version is " + (String)tokens.get(1) + ", expected 10");
                }
                if (((String)tokens.get(0)).equals("numFrames")) {
                    int numFrames = MD5Loader.parseInt((String)tokens.get(1));
                    animation.frames = new MD5Joints[numFrames];
                    animation.bounds = new BoundingBox[numFrames];
                }
                if (((String)tokens.get(0)).equals("numJoints")) {
                    int numJoints = MD5Loader.parseInt((String)tokens.get(1));
                    for (i2 = 0; i2 < animation.frames.length; ++i2) {
                        animation.frames[i2] = new MD5Joints();
                        animation.frames[i2].numJoints = numJoints;
                        animation.frames[i2].names = new String[numJoints];
                        animation.frames[i2].joints = new float[numJoints * 8];
                    }
                    jointInfos = new JointInfo[numJoints];
                    baseFrame = new BaseFrameJoint[numJoints];
                }
                if (((String)tokens.get(0)).equals("frameRate")) {
                    int frameRate;
                    animation.frameRate = frameRate = MD5Loader.parseInt((String)tokens.get(1));
                    animation.secondsPerFrame = 1.0f / (float)frameRate;
                }
                if (((String)tokens.get(0)).equals("numAnimatedComponents")) {
                    int numAnimatedComponents = MD5Loader.parseInt((String)tokens.get(1));
                    animFrameData = new float[numAnimatedComponents];
                }
                if (((String)tokens.get(0)).equals("hierarchy")) {
                    for (i = 0; i < jointInfos.length; ++i) {
                        line = reader.readLine();
                        MD5Loader.tokenize(line, tokens);
                        if (tokens.size() == 0 || ((String)tokens.get(0)).equals("//")) {
                            --i;
                            continue;
                        }
                        JointInfo jointInfo = new JointInfo();
                        jointInfo.name = (String)tokens.get(0);
                        jointInfo.parent = MD5Loader.parseInt((String)tokens.get(1));
                        jointInfo.flags = MD5Loader.parseInt((String)tokens.get(2));
                        jointInfo.startIndex = MD5Loader.parseInt((String)tokens.get(3));
                        jointInfos[i] = jointInfo;
                    }
                }
                if (((String)tokens.get(0)).equals("bounds")) {
                    for (i = 0; i < animation.bounds.length; ++i) {
                        line = reader.readLine();
                        MD5Loader.tokenize(line, tokens);
                        if (tokens.size() == 0) {
                            --i;
                            continue;
                        }
                        BoundingBox bounds = new BoundingBox();
                        bounds.min.x = MD5Loader.parseFloat((String)tokens.get(1));
                        bounds.min.y = MD5Loader.parseFloat((String)tokens.get(2));
                        bounds.min.z = MD5Loader.parseFloat((String)tokens.get(3));
                        bounds.max.x = MD5Loader.parseFloat((String)tokens.get(6));
                        bounds.max.y = MD5Loader.parseFloat((String)tokens.get(7));
                        bounds.max.z = MD5Loader.parseFloat((String)tokens.get(8));
                        animation.bounds[i] = bounds;
                    }
                }
                if (((String)tokens.get(0)).equals("baseframe")) {
                    for (i = 0; i < baseFrame.length; ++i) {
                        line = reader.readLine();
                        MD5Loader.tokenize(line, tokens);
                        if (tokens.size() == 0) {
                            --i;
                            continue;
                        }
                        BaseFrameJoint joint = new BaseFrameJoint();
                        joint.pos.x = MD5Loader.parseFloat((String)tokens.get(1));
                        joint.pos.y = MD5Loader.parseFloat((String)tokens.get(2));
                        joint.pos.z = MD5Loader.parseFloat((String)tokens.get(3));
                        joint.orient.x = MD5Loader.parseFloat((String)tokens.get(6));
                        joint.orient.y = MD5Loader.parseFloat((String)tokens.get(7));
                        joint.orient.z = MD5Loader.parseFloat((String)tokens.get(8));
                        joint.orient.computeW();
                        baseFrame[i] = joint;
                    }
                }
                if (!((String)tokens.get(0)).equals("frame")) continue;
                int frameIndex = MD5Loader.parseInt((String)tokens.get(1));
                i2 = 0;
                line = reader.readLine();
                MD5Loader.tokenize(line, tokens);
                while (!((String)tokens.get(0)).equals("}")) {
                    for (int j = 0; j < tokens.size(); ++j) {
                        animFrameData[i2++] = MD5Loader.parseFloat((String)tokens.get(j));
                    }
                    line = reader.readLine();
                    MD5Loader.tokenize(line, tokens);
                }
                MD5Loader.buildFrameSkeleton(jointInfos, baseFrame, animFrameData, animation, frameIndex);
            }
            return animation;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static float parseFloat(String value) {
        float front = 0.0f;
        float back = 0.0f;
        float sign = 1.0f;
        boolean isBack = false;
        int count = 1;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '-') {
                sign = -1.0f;
                continue;
            }
            if (c == '+') continue;
            if (c == '.' || c == ',') {
                isBack = true;
                continue;
            }
            float val = c - 48;
            if (!isBack) {
                front = front * 10.0f + val;
                continue;
            }
            back += val * (1.0f / (float)Math.pow(10.0, count++));
        }
        return sign * (front + back);
    }

    private static int parseInt(String value) {
        int front = 0;
        int sign = 1;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '-') {
                sign = -1;
                continue;
            }
            if (c == '+') continue;
            if (c == '.' || c == ',') break;
            int val = c - 48;
            front = front * 10 + val;
        }
        return sign * front;
    }

    private static void buildFrameSkeleton(JointInfo[] jointInfos, BaseFrameJoint[] baseFrame, float[] animFrameData, MD5Animation animation, int frameIndex) {
        MD5Joints skelFrame = animation.frames[frameIndex];
        for (int i = 0; i < jointInfos.length; ++i) {
            BaseFrameJoint baseJoint = baseFrame[i];
            Vector3 animatedPos = new Vector3();
            MD5Quaternion animatedOrient = new MD5Quaternion();
            int j = 0;
            animatedPos.set(baseJoint.pos);
            animatedOrient.set(baseJoint.orient);
            if ((jointInfos[i].flags & 1) != 0) {
                animatedPos.x = animFrameData[jointInfos[i].startIndex + j];
                ++j;
            }
            if ((jointInfos[i].flags & 2) != 0) {
                animatedPos.y = animFrameData[jointInfos[i].startIndex + j];
                ++j;
            }
            if ((jointInfos[i].flags & 4) != 0) {
                animatedPos.z = animFrameData[jointInfos[i].startIndex + j];
                ++j;
            }
            if ((jointInfos[i].flags & 8) != 0) {
                animatedOrient.x = animFrameData[jointInfos[i].startIndex + j];
                ++j;
            }
            if ((jointInfos[i].flags & 0x10) != 0) {
                animatedOrient.y = animFrameData[jointInfos[i].startIndex + j];
                ++j;
            }
            if ((jointInfos[i].flags & 0x20) != 0) {
                animatedOrient.z = animFrameData[jointInfos[i].startIndex + j];
                ++j;
            }
            animatedOrient.computeW();
            int thisJointIdx = i << 3;
            skelFrame.names[i] = jointInfos[i].name;
            skelFrame.joints[thisJointIdx] = jointInfos[i].parent;
            if (jointInfos[i].parent < 0) {
                skelFrame.joints[thisJointIdx + 1] = animatedPos.x;
                skelFrame.joints[thisJointIdx + 2] = animatedPos.y;
                skelFrame.joints[thisJointIdx + 3] = animatedPos.z;
                skelFrame.joints[thisJointIdx + 4] = animatedOrient.x;
                skelFrame.joints[thisJointIdx + 5] = animatedOrient.y;
                skelFrame.joints[thisJointIdx + 6] = animatedOrient.z;
                skelFrame.joints[thisJointIdx + 7] = animatedOrient.w;
                continue;
            }
            int parentJointIdx = jointInfos[i].parent << 3;
            MD5Loader.parentPos.x = skelFrame.joints[parentJointIdx + 1];
            MD5Loader.parentPos.y = skelFrame.joints[parentJointIdx + 2];
            MD5Loader.parentPos.z = skelFrame.joints[parentJointIdx + 3];
            MD5Loader.parentOrient.x = skelFrame.joints[parentJointIdx + 4];
            MD5Loader.parentOrient.y = skelFrame.joints[parentJointIdx + 5];
            MD5Loader.parentOrient.z = skelFrame.joints[parentJointIdx + 6];
            MD5Loader.parentOrient.w = skelFrame.joints[parentJointIdx + 7];
            parentOrient.rotate(animatedPos);
            skelFrame.joints[thisJointIdx + 1] = animatedPos.x + MD5Loader.parentPos.x;
            skelFrame.joints[thisJointIdx + 2] = animatedPos.y + MD5Loader.parentPos.y;
            skelFrame.joints[thisJointIdx + 3] = animatedPos.z + MD5Loader.parentPos.z;
            parentOrient.multiply(animatedOrient);
            parentOrient.normalize();
            skelFrame.joints[thisJointIdx + 4] = MD5Loader.parentOrient.x;
            skelFrame.joints[thisJointIdx + 5] = MD5Loader.parentOrient.y;
            skelFrame.joints[thisJointIdx + 6] = MD5Loader.parentOrient.z;
            skelFrame.joints[thisJointIdx + 7] = MD5Loader.parentOrient.w;
        }
    }

    private static void tokenize(String line, List<String> tokens) {
        tokens.clear();
        StringTokenizer tokenizer = new StringTokenizer(line);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
    }

    static class BaseFrameJoint {
        public final Vector3 pos = new Vector3();
        public final MD5Quaternion orient = new MD5Quaternion();

        BaseFrameJoint() {
        }
    }

    static class JointInfo {
        public String name;
        public int parent;
        public int flags;
        public int startIndex;

        JointInfo() {
        }
    }
}

