/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class PolygonRegion {
    private float[] texCoords;
    private float[] localVertices;
    private TextureRegion region;

    public PolygonRegion(TextureRegion region, FileHandle file) {
        this.region = region;
        if (file == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        this.loadPolygonDefinition(file);
    }

    public PolygonRegion(TextureRegion region, float[] vertices) {
    }

    private void loadPolygonDefinition(FileHandle file) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.read()), 64);
        try {
            String line;
            block9: while ((line = reader.readLine()) != null) {
                if (line.startsWith("v")) {
                    String[] vertices = line.substring(1).trim().split(",");
                    this.localVertices = new float[vertices.length];
                    int i = 0;
                    while (true) {
                        if (i >= vertices.length) continue block9;
                        this.localVertices[i] = Float.parseFloat(vertices[i]);
                        this.localVertices[i + 1] = Float.parseFloat(vertices[i + 1]);
                        i += 2;
                    }
                }
                if (!line.startsWith("u")) continue;
                String[] texCoords = line.substring(1).trim().split(",");
                float[] localTexCoords = new float[texCoords.length];
                for (int i = 0; i < texCoords.length; i += 2) {
                    localTexCoords[i] = Float.parseFloat(texCoords[i]);
                    localTexCoords[i + 1] = Float.parseFloat(texCoords[i + 1]);
                }
                this.texCoords = this.calculateAtlasTexCoords(localTexCoords);
            }
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error reading polygon shape file: " + file);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ignored) {}
        }
    }

    private float[] calculateAtlasTexCoords(float[] localTexCoords) {
        float uvWidth = this.region.u2 - this.region.u;
        float uvHeight = this.region.v2 - this.region.v;
        for (int i = 0; i < localTexCoords.length; i += 2) {
            localTexCoords[i] = this.region.u + localTexCoords[i] * uvWidth;
            localTexCoords[i + 1] = this.region.v + localTexCoords[i + 1] * uvHeight;
        }
        return localTexCoords;
    }

    public float[] getLocalVertices() {
        return this.localVertices;
    }

    public float[] getTextureCoords() {
        return this.texCoords;
    }

    public TextureRegion getRegion() {
        return this.region;
    }
}

