/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;

public class SkinLoader
extends AsynchronousAssetLoader<Skin, SkinParameter> {
    public SkinLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, SkinParameter parameter) {
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>();
        TextureLoader.TextureParameter textureParam = new TextureLoader.TextureParameter();
        textureParam.minFilter = Texture.TextureFilter.Linear;
        textureParam.magFilter = Texture.TextureFilter.Linear;
        if (parameter == null) {
            deps.add(new AssetDescriptor<Texture>(this.resolve(fileName).pathWithoutExtension() + ".png", Texture.class, textureParam));
        } else {
            deps.add(new AssetDescriptor<Texture>(parameter.texturePath, Texture.class, textureParam));
        }
        return deps;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, SkinParameter parameter) {
    }

    @Override
    public Skin loadSync(AssetManager manager, String fileName, SkinParameter parameter) {
        String texturePath = parameter == null ? this.resolve(fileName).pathWithoutExtension() + ".png" : parameter.texturePath;
        Texture texture = manager.get(texturePath, Texture.class);
        return new Skin(this.resolve(fileName), texture);
    }

    public static class SkinParameter
    extends AssetLoaderParameters<Skin> {
        public final String texturePath;

        public SkinParameter(String texturePath) {
            this.texturePath = texturePath;
        }
    }
}

