/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.tiled.TiledLoader;
import com.badlogic.gdx.graphics.g2d.tiled.TiledMap;
import com.badlogic.gdx.graphics.g2d.tiled.TiledObject;
import java.util.ArrayList;
import java.util.HashMap;

public class World_Game
extends World {
    public static final int SOUND_STEP1 = 0;
    public static final int SOUND_STEP2 = 1;
    public static final int SOUND_PICKUP = 2;
    public static final int SOUND_DOWN = 3;
    public static final int SOUND_PAIN = 4;
    public static final int SOUND_FINISH = 5;
    public static final int SOUND_OVER = 6;
    public static final int SOUND_FIREBALL = 7;
    public static final int SOUND_BOX = 8;
    public Texture tilesTexture;
    public Texture bgTexture;
    public Texture hudTexture;
    public TextureRegion[][] tilesTRegion;
    public Texture objectsTexture;
    public TextureRegion[][] objectsTRegion;
    public TiledMap map;
    public User user;
    public int lastConfirm;
    private boolean bgScroll;
    private float bgX;
    private int goldCount;
    private ArrayList<String> levels = new ArrayList();
    private int level;

    public World_Game(App a) {
        super(a);
        this.levels.add("easy01.tmx");
        this.levels.add("easy02.tmx");
        this.levels.add("easy03.tmx");
        this.levels.add("easy04.tmx");
        this.levels.add("easy05.tmx");
        this.levels.add("easy06.tmx");
        this.levels.add("normal01.tmx");
        this.levels.add("normal02.tmx");
        this.levels.add("normal03.tmx");
        this.levels.add("normal04.tmx");
        this.levels.add("normal05.tmx");
        this.levels.add("normal06.tmx");
        this.levels.add("hard01.tmx");
        this.levels.add("hard02.tmx");
        this.levels.add("hard03.tmx");
        this.level = this.app.config.getInt("level", 0);
    }

    @Override
    public void create() {
        this.sound = new Sound[9];
        this.sound[0] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/step1.ogg"));
        this.sound[1] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/step2.ogg"));
        this.sound[2] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/pickup.ogg"));
        this.sound[3] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/down.ogg"));
        this.sound[4] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/pain.ogg"));
        this.sound[5] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/finish.ogg"));
        this.sound[6] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/over.ogg"));
        this.sound[7] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/fireball.ogg"));
        this.sound[8] = Gdx.audio.newSound(Gdx.files.internal("data/sounds/box.ogg"));
        this.grid = new Grid(25, 19);
        this.objectsTexture = new Texture(Gdx.files.internal("data/textures/objects.png"));
        TextureRegion tregion = new TextureRegion(this.objectsTexture);
        this.objectsTRegion = tregion.split(20, 20);
        this.hudTexture = new Texture(Gdx.files.internal("data/textures/hud.png"));
    }

    public int getLevelCount() {
        return this.levels.size();
    }

    public void reset() {
        this.level = 0;
        this.app.config.setInt("level", 0);
        this.user.reset();
    }

    public void init() {
        App_MinerMan app_mm = (App_MinerMan)this.app;
        this.user = app_mm.user;
    }

    public int getGoldCount() {
        return this.goldCount;
    }

    private void createGrid(int x, int y, int n) {
        if (n == -1) {
            return;
        }
        if (n >= 32 && n <= 63) {
            return;
        }
        if (n < 32) {
            this.grid.set(x, 19 - y, 1);
        } else if (n < 96) {
            this.grid.set(x, 19 - y, 3);
        } else if (n < 128) {
            this.grid.set(x, 19 - y, 4);
        } else if (n < 160) {
            this.grid.set(x, 19 - y, 8);
        }
    }

    public void clear() {
        this.goldCount = 0;
        this.entityMgr.dispose();
        this.user.clear();
        this.removeSprites();
        this.grid.clear();
    }

    public void load() {
        this.clear();
        if (this.level >= this.levels.size()) {
            this.level = 0;
        }
        String levelPath = "data/levels/" + this.levels.get(this.level);
        this.map = null;
        this.map = TiledLoader.createMap(Gdx.files.internal(levelPath));
        HashMap<String, String> props = this.map.properties;
        if (props.containsKey("bg")) {
            this.bgTexture = new Texture(Gdx.files.internal(props.get("bg")));
            this.bgTexture.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        }
        this.bgScroll = props.containsKey("bg_scroll");
        String tilesetPath = props.get("tileset");
        this.tilesTexture = new Texture(Gdx.files.internal(tilesetPath));
        this.app.playMusic(tilesetPath);
        TextureRegion tregion = new TextureRegion(this.tilesTexture);
        this.tilesTRegion = tregion.split(16, 16);
        int[][] tiles1 = this.map.layers.get((int)0).tiles;
        int[][] tiles2 = this.map.layers.get((int)1).tiles;
        int j = 0;
        while (j < tiles1.length) {
            int i = 0;
            while (i < tiles1[j].length) {
                this.createGrid(i, j, tiles1[j][i] - 1);
                this.createGrid(i, j, tiles2[j][i] - 1);
                ++i;
            }
            ++j;
        }
        ArrayList<TiledObject> objects = this.map.objectGroups.get((int)0).objects;
        for (TiledObject obj : objects) {
            float f;
            float x = obj.x;
            float y = 304 - obj.y;
            if (obj.type.equals("player")) {
                Entity_Player player = new Entity_Player(this);
                player.position.x = x;
                player.position.y = y;
                player.create();
                this.addEntity(player);
                this.user.setEntity(player);
                continue;
            }
            if (obj.type.equals("hearth")) {
                Entity_Hearth hearth = new Entity_Hearth(this);
                hearth.position.x = x;
                hearth.position.y = y;
                hearth.create();
                this.addEntity(hearth);
                continue;
            }
            if (obj.type.equals("exit")) {
                Entity_Exit exit = new Entity_Exit(this);
                exit.position.x = x;
                exit.position.y = y;
                exit.create();
                this.addEntity(exit);
                continue;
            }
            if (obj.type.equals("gold")) {
                Entity_Gold gold = new Entity_Gold(this);
                gold.position.x = x;
                gold.position.y = y;
                gold.create();
                ++this.goldCount;
                this.addEntity(gold);
                continue;
            }
            if (obj.type.equals("bat")) {
                Entity_Bat bat = new Entity_Bat(this);
                bat.position.x = x;
                bat.position.y = y;
                bat.create();
                this.addEntity(bat);
                continue;
            }
            if (obj.type.equals("spider")) {
                Entity_Spider spider = new Entity_Spider(this);
                spider.position.x = x;
                spider.position.y = y;
                if (obj.properties.containsKey("dir")) {
                    f = Float.valueOf(obj.properties.get("dir").trim()).floatValue();
                    spider.setStartDir(f > 0.0f);
                }
                if (obj.properties.containsKey("speed")) {
                    f = Float.valueOf(obj.properties.get("speed").trim()).floatValue();
                    spider.setSpeed(f);
                }
                spider.create();
                this.addEntity(spider);
                continue;
            }
            if (obj.type.equals("worm")) {
                Entity_Worm worm = new Entity_Worm(this);
                worm.position.x = x;
                worm.position.y = y;
                if (obj.properties.containsKey("dir")) {
                    f = Float.valueOf(obj.properties.get("dir").trim()).floatValue();
                    worm.setStartDir(f > 0.0f);
                }
                if (obj.properties.containsKey("speed")) {
                    f = Float.valueOf(obj.properties.get("speed").trim()).floatValue();
                    worm.setSpeed(f);
                }
                worm.create();
                this.addEntity(worm);
                continue;
            }
            if (obj.type.equals("box")) {
                Entity_Box box = new Entity_Box(this);
                box.position.x = x;
                box.position.y = y;
                box.create();
                this.addEntity(box);
                continue;
            }
            if (!obj.type.equals("fireball")) continue;
            Entity_Fireball fireball = new Entity_Fireball(this);
            fireball.position.x = x;
            fireball.position.y = y;
            if (obj.properties.containsKey("wait")) {
                f = Float.valueOf(obj.properties.get("wait").trim()).floatValue();
                fireball.setWaitTime(f);
            }
            if (obj.properties.containsKey("speed")) {
                f = Float.valueOf(obj.properties.get("speed").trim()).floatValue();
                fireball.setSpeed(f);
            }
            fireball.create();
            this.addEntity(fireball);
        }
    }

    @Override
    public void update() {
        App_MinerMan app_mm = (App_MinerMan)this.app;
        if (App.keyPressed == 131) {
            app_mm.setWorld(app_mm.menu);
        } else if (App.keyPressed == 46) {
            this.lastConfirm = 5;
            app_mm.confirm.msg = "RESTART LEVEL";
            app_mm.confirm.okText = "Restart level";
            app_mm.confirm.cancelText = "Back to game";
            app_mm.confirm.prevWorld = this;
            app_mm.confirm.init();
            app_mm.setWorld(app_mm.confirm);
        }
        app_mm.user.update();
        super.update();
    }

    private void drawTileLayer(int num) {
        int[][] tiles = this.map.layers.get((int)num).tiles;
        int j = 0;
        while (j < tiles.length) {
            int i = 0;
            while (i < tiles[j].length) {
                int n = tiles[j][i] - 1;
                if (n != -1) {
                    this.spriteBatch.draw(this.tilesTRegion[n / 32][n % 32], (float)(16 * i), (float)(16 * (18 - j)));
                }
                ++i;
            }
            ++j;
        }
    }

    public void renderScene() {
        World_Game.camera.position.x = 200.0f;
        World_Game.camera.position.y = 150.0f;
        World_Game.camera.zoom = 0.5f;
        this.useCamera();
        if (this.bgTexture != null) {
            if (this.bgScroll) {
                this.bgX += 5.0E-4f;
                this.spriteBatch.draw(this.bgTexture, 0.0f, 0.0f, 400.0f, 300.0f, this.bgX, 0.5859f, 0.78125f + this.bgX, 0.0f);
            } else {
                this.spriteBatch.draw(this.bgTexture, 0.0f, 0.0f, 0, 0, 400, 300);
            }
        }
        this.drawTileLayer(0);
        this.renderSprites(0);
        this.drawTileLayer(1);
        this.renderSprites(1);
        this.spriteBatch.draw(this.hudTexture, 0.0f, 0.0f, 0, 0, 400, 300);
        this.user.render(this.spriteBatch);
    }

    @Override
    public void render() {
        this.clearScreen();
        this.spriteBatch.begin();
        this.renderScene();
        this.spriteBatch.end();
    }

    @Override
    public void confirmOk() {
        App_MinerMan app_mm = (App_MinerMan)this.app;
        switch (this.lastConfirm) {
            case 1: {
                this.load();
                break;
            }
            case 3: {
                this.reset();
                this.load();
                break;
            }
            case 2: {
                ++this.level;
                this.app.config.setInt("level", this.level);
                this.user.save();
                if (this.level >= this.levels.size()) {
                    this.app.playMusic("data/textures/congrat.png");
                    this.lastConfirm = 4;
                    app_mm.confirm.msg = "CONGRATULATIONS!";
                    app_mm.confirm.okText = "Go to credits";
                    app_mm.confirm.cancelText = "Back to menu";
                    app_mm.confirm.prevWorld = this;
                    app_mm.confirm.init();
                    app_mm.setWorld(app_mm.confirm);
                    app_mm.menu.activeId = 1;
                    app_mm.menu.itemContinue.disabled = true;
                    break;
                }
                this.load();
                break;
            }
            case 4: {
                app_mm.setWorld(app_mm.credits);
                break;
            }
            case 5: {
                this.load();
            }
        }
    }

    @Override
    public void confirmCancel() {
        App_MinerMan app_mm = (App_MinerMan)this.app;
        switch (this.lastConfirm) {
            case 1: 
            case 3: 
            case 4: {
                app_mm.setWorld(app_mm.menu);
            }
        }
    }
}

