/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class EntityManager {
    int entityIndex;
    int itemIndex;
    int useableIndex;
    int seeBlockIndex;
    int enemyIndex;
    ArrayList<Entity> entities = new ArrayList();
    ArrayList<Entity> items = new ArrayList();
    ArrayList<Entity> seeBlocks = new ArrayList();
    ArrayList<Entity> useables = new ArrayList();
    ArrayList<Entity> enemies = new ArrayList();
    ArrayList<Entity> removes = new ArrayList();
    App app;

    public EntityManager(App a) {
        this.app = a;
    }

    public void add(Entity e) {
        this.entities.add(e);
        if (e.item) {
            this.items.add(e);
        } else if (e.useable) {
            this.useables.add(e);
        } else if (e.enemy) {
            this.enemies.add(e);
        }
        if (e.seeBlock) {
            this.seeBlocks.add(e);
        }
    }

    public void remove(Entity e) {
        this.removes.add(e);
    }

    public void update() {
        Entity e;
        float dt = this.app.getDeltaTime();
        int size = this.entities.size();
        int i = 0;
        while (i < size) {
            e = this.entities.get(i);
            e.dt = dt;
            e.update();
            ++i;
        }
        size = this.removes.size();
        i = 0;
        while (i < size) {
            e = this.removes.get(i);
            this.entities.remove(e);
            if (e.item) {
                this.items.remove(e);
            }
            if (e.useable) {
                this.useables.remove(e);
            }
            if (e.enemy) {
                this.enemies.remove(e);
            }
            if (e.seeBlock) {
                this.seeBlocks.remove(e);
            }
            e.remove();
            ++i;
        }
        this.removes.clear();
    }

    public Entity getFirst() {
        this.entityIndex = 0;
        return this.entities.get(this.entityIndex);
    }

    public boolean hasNext() {
        return this.entities.size() > this.entityIndex;
    }

    public Entity getNext() {
        ++this.entityIndex;
        if (this.entityIndex >= this.entities.size()) {
            return null;
        }
        return this.entities.get(this.entityIndex);
    }

    public Entity getFirstUseable() {
        this.useableIndex = 0;
        if (this.useables.isEmpty()) {
            return null;
        }
        return this.useables.get(this.useableIndex);
    }

    public boolean hasNextUseable() {
        return this.useables.size() > this.useableIndex;
    }

    public Entity getNextUseable() {
        ++this.useableIndex;
        if (this.useableIndex >= this.useables.size()) {
            return null;
        }
        return this.useables.get(this.useableIndex);
    }

    public Entity getFirstItem() {
        this.itemIndex = 0;
        if (this.items.isEmpty()) {
            return null;
        }
        return this.items.get(this.itemIndex);
    }

    public boolean hasNextItem() {
        return this.items.size() > this.itemIndex;
    }

    public Entity getNextItem() {
        ++this.itemIndex;
        if (this.itemIndex >= this.items.size()) {
            return null;
        }
        return this.items.get(this.itemIndex);
    }

    public Entity getFirstSeeBlock() {
        this.seeBlockIndex = 0;
        if (this.seeBlocks.isEmpty()) {
            return null;
        }
        return this.seeBlocks.get(this.seeBlockIndex);
    }

    public boolean hasNextSeeBlock() {
        return this.seeBlocks.size() > this.seeBlockIndex;
    }

    public Entity getNextSeeBlock() {
        ++this.seeBlockIndex;
        if (this.seeBlockIndex >= this.seeBlocks.size()) {
            return null;
        }
        return this.seeBlocks.get(this.seeBlockIndex);
    }

    public Entity getFirstEnemy() {
        this.enemyIndex = 0;
        if (this.enemies.isEmpty()) {
            return null;
        }
        return this.enemies.get(this.enemyIndex);
    }

    public boolean hasNextEnemy() {
        return this.enemies.size() > this.enemyIndex;
    }

    public Entity getNextEnemy() {
        ++this.enemyIndex;
        if (this.enemyIndex >= this.enemies.size()) {
            return null;
        }
        return this.enemies.get(this.enemyIndex);
    }

    public void dispose() {
        int size = this.entities.size();
        int i = 0;
        while (i < size) {
            Entity e = this.entities.get(i);
            e.dispose();
            Object var3_3 = null;
            ++i;
        }
        this.entities.clear();
        this.useables.clear();
        this.items.clear();
        this.seeBlocks.clear();
        this.enemies.clear();
    }
}

